/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.util.Messages;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceQuery;

public final class QueryResults {
    private final TransactionContext _tx;
    private final LockEngine _engine;
    private final PersistenceQuery _query;
    private final AccessMode _accessMode;
    private Identity _lastIdentity;

    public QueryResults(TransactionContext tx, LockEngine engine, PersistenceQuery query, AccessMode accessMode, Database db) {
        this._tx = tx;
        this._engine = engine;
        this._query = query;
        this._accessMode = engine.getClassMolder(this._query.getResultType()).getAccessMode(accessMode);
    }

    public TransactionContext getTransaction() {
        return this._tx;
    }

    public PersistenceQuery getQuery() {
        return this._query;
    }

    public Class getResultType() {
        return this._query.getResultType();
    }

    public Object nextIdentity() throws TransactionNotInProgressException, PersistenceException {
        if (this._tx.getStatus() != 0) {
            throw new TransactionNotInProgressException(Messages.message((String)"persist.noTransaction"));
        }
        try {
            this._lastIdentity = this._query.nextIdentity(this._lastIdentity);
        }
        catch (PersistenceException except) {
            this._lastIdentity = null;
            throw except;
        }
        return this._lastIdentity;
    }

    public Object fetch() throws TransactionNotInProgressException, PersistenceException, ObjectNotFoundException, LockNotGrantedException {
        if (this._tx.getStatus() != 0) {
            throw new TransactionNotInProgressException(Messages.message((String)"persist.noTransaction"));
        }
        if (this._lastIdentity == null) {
            throw new IllegalStateException(Messages.message((String)"jdo.fetchNoNextIdentity"));
        }
        ClassMolder handler = this._engine.getClassMolder(this._query.getResultType());
        ProposedEntity proposedValue = new ProposedEntity(handler);
        proposedValue.setProposedEntityClass(this._query.getResultType());
        Object object = this._tx.load(this._lastIdentity, proposedValue, this._accessMode, this);
        if (proposedValue.isExpanded()) {
            object = proposedValue.getEntity();
        }
        return object;
    }

    public void close() {
        this._query.close();
    }

    public boolean absolute(int row) throws PersistenceException {
        return this._query.absolute(row);
    }

    public int size() throws PersistenceException {
        return this._query.size();
    }
}

