/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EHCache
extends AbstractBaseCache {
    private static final Log LOG = LogFactory.getLog(EHCache.class);
    public static final String TYPE = "ehcache";
    public static final String IMPLEMENTATION = "net.sf.ehcache.CacheManager";
    private static final Class<?>[] TYPES_GET_CACHE = new Class[]{String.class};
    private static final Class<?>[] TYPES_GET = new Class[]{Object.class};
    private static final Class<?>[] TYPES_REMOVE = new Class[]{Object.class};
    private static final Class<?>[] TYPES_ELEMENT_CONSTRUCTOR = new Class[]{Object.class, Object.class};
    private Object _cache;
    private Method _getMethod;
    private Method _putMethod;
    private Method _getSizeMethod;
    private Method _removeMethod;
    private Method _removeAllMethod;
    private Method _getValueMethod;
    private Method _isExpiredMethod;
    private Class<?> _elementClass;
    private Constructor<?> _elementConstructor;

    @Override
    public void initialize(Properties params) throws CacheAcquireException {
        this.initialize(IMPLEMENTATION, params);
    }

    public void initialize(String implementation, Properties params) throws CacheAcquireException {
        String msg;
        super.initialize(params);
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            this.invokeStaticMethod(cls, "create", null, null);
            Object factory = this.invokeStaticMethod(cls, "getInstance", null, null);
            Boolean cacheExists = (Boolean)this.invokeMethod(factory, "cacheExists", new Class[]{String.class}, new Object[]{this.getName()});
            if (!cacheExists.booleanValue()) {
                this.invokeMethod(factory, "addCache", TYPES_GET_CACHE, new Object[]{this.getName()});
            }
            this._cache = this.invokeMethod(factory, "getCache", TYPES_GET_CACHE, new Object[]{this.getName()});
        }
        catch (Exception e) {
            String msg2 = "Error creating EHCache cache: " + e.getMessage();
            LOG.error((Object)msg2, (Throwable)e);
            throw new CacheAcquireException(msg2, e);
        }
        Class<?> cls = this._cache.getClass();
        try {
            this._elementClass = Class.forName("net.sf.ehcache.Element");
            this._getValueMethod = this._elementClass.getMethod("getValue", null);
            this._isExpiredMethod = this._elementClass.getMethod("isExpired", null);
        }
        catch (Exception e) {
            msg = "Failed to instantiate Class for type 'net.sf.ehcache.Element': " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
        try {
            this._getSizeMethod = cls.getMethod("getSize", null);
            this._getMethod = cls.getMethod("get", TYPES_GET);
            this._putMethod = cls.getMethod("put", this._elementClass);
            this._removeMethod = cls.getMethod("remove", TYPES_REMOVE);
            this._removeAllMethod = cls.getMethod("removeAll", null);
            this._elementConstructor = this._elementClass.getConstructor(TYPES_ELEMENT_CONSTRUCTOR);
            this._removeAllMethod = cls.getMethod("removeAll", null);
        }
        catch (Exception e) {
            msg = "Failed to find method on EHCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
    }

    @Override
    public int size() {
        Integer result = new Integer(-1);
        try {
            result = (Integer)this._getSizeMethod.invoke(this._cache, (Object[])null);
        }
        catch (Exception e) {
            String msg = "Failed to call method on EHCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue(Object)");
    }

    @Override
    public Object get(Object key) {
        Object result = null;
        try {
            Object elementInCache = this._getMethod.invoke(this._cache, key);
            if (elementInCache == null) {
                return null;
            }
            Boolean isExpired = (Boolean)this._isExpiredMethod.invoke(elementInCache, (Object[])null);
            if (isExpired.equals(Boolean.FALSE)) {
                result = this._getValueMethod.invoke(elementInCache, (Object[])null);
            }
        }
        catch (Exception e) {
            String msg = "Failed to call method on EHCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        return result;
    }

    @Override
    public Object put(Object key, Object value) {
        Boolean result = Boolean.FALSE;
        try {
            result = this._elementConstructor.newInstance(key, value);
            this._putMethod.invoke(this._cache, result);
        }
        catch (Exception e) {
            String msg = "Failed to call method on EHCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = this.get(key);
        try {
            this._removeMethod.invoke(this._cache, String.valueOf(key));
        }
        catch (Exception e) {
            String msg = "Failed to call method on EHCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            this.put(key, entry.getValue());
        }
    }

    @Override
    public void clear() {
        try {
            this._removeAllMethod.invoke(this._cache, (Object[])null);
        }
        catch (Exception e) {
            String msg = "Failed to call method on EHCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException("keySet()");
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("values()");
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    public void shutdown(String implementation) {
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            if (cls != null) {
                Object factory = this.invokeStaticMethod(cls, "getInstance", null, null);
                Method method = cls.getMethod("shutdown", cls);
                method.invoke(factory, (Object[])null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Problem shutting down Coherence cluster member", (Throwable)e);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

