/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OsCache
extends AbstractBaseCache {
    private static final Log LOG = LogFactory.getLog(OsCache.class);
    public static final String TYPE = "oscache";
    public static final String IMPLEMENTATION = "com.opensymphony.oscache.general.GeneralCacheAdministrator";
    public static final String NEEDS_REFRESH_EXCEPTION = "com.opensymphony.oscache.base.NeedsRefreshException";
    private static final Class<?>[] TYPES_GET = new Class[]{String.class};
    private static final Class<?>[] TYPES_CANCEL = TYPES_GET;
    private static final Class<?>[] TYPES_PUT = new Class[]{String.class, Object.class, String[].class};
    private static final Class<?>[] TYPES_REMOVE = TYPES_GET;
    private static final Class<?>[] TYPES_CLEAR = TYPES_GET;
    private final Object _cache;
    private Method _getMethod;
    private Method _cancelMethod;
    private Method _putMethod;
    private Method _removeMethod;
    private Method _clearMethod;
    private String[] _groups;

    public OsCache(Object cache) {
        this._cache = cache;
    }

    @Override
    public void initialize(Properties params) throws CacheAcquireException {
        super.initialize(params);
        Class<?> cls = this._cache.getClass();
        try {
            this._getMethod = cls.getMethod("getFromCache", TYPES_GET);
            this._cancelMethod = cls.getMethod("cancelUpdate", TYPES_CANCEL);
            this._putMethod = cls.getMethod("putInCache", TYPES_PUT);
            this._removeMethod = cls.getMethod("flushEntry", TYPES_REMOVE);
            this._clearMethod = cls.getMethod("flushGroup", TYPES_CLEAR);
        }
        catch (Exception e) {
            String msg = "Failed to find method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
        this._groups = new String[]{this.getName()};
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size()");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty()");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue(Object)");
    }

    @Override
    public Object get(Object key) {
        try {
            return this._getMethod.invoke(this._cache, String.valueOf(key));
        }
        catch (InvocationTargetException e) {
            String cause = e.getTargetException().getClass().getName();
            if (cause.equals(NEEDS_REFRESH_EXCEPTION)) {
                this.invokeCacheMethod(this._cancelMethod, new Object[]{String.valueOf(key)});
                return null;
            }
            String msg = "Failed to call method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (Exception e) {
            String msg = "Failed to call method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        this.invokeCacheMethod(this._putMethod, new Object[]{String.valueOf(key), value, this._groups});
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        Object oldValue = this.get(key);
        this.invokeCacheMethod(this._removeMethod, new Object[]{String.valueOf(key)});
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            this.invokeCacheMethod(this._putMethod, new Object[]{key, entry.getValue(), this._groups});
        }
    }

    @Override
    public void clear() {
        this.invokeCacheMethod(this._clearMethod, new Object[]{this.getName()});
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException("keySet()");
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException("values()");
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    private Object invokeCacheMethod(Method method, Object[] arguments) {
        try {
            return method.invoke(this._cache, arguments);
        }
        catch (Exception e) {
            String msg = "Failed to call method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }
}

