/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CallableStatementProxy
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(CallableStatementProxy.class);
    private static final Set<String> SET_METHODS = new HashSet<String>(Arrays.asList("setArray", "setBigDecimal", "setBinaryStream", "setBlob", "setBoolean", "setByte", "setBytes", "setCharacterStream", "setClob", "setDate", "setDouble", "setFloat", "setInt", "setLong", "setObject", "setShort", "setString", "setTime", "setTimestamp", "setURL"));
    private final CallableStatement _callableStatement;
    private String _sqlStatement;
    private final Map<Object, Object> _parameters = new HashMap<Object, Object>();
    private final List<String> _batchStatements = new ArrayList<String>();

    protected CallableStatementProxy(CallableStatement stmt, String sql) {
        this._callableStatement = stmt;
        this._sqlStatement = sql;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating callable statement proxy for SQL statement " + sql));
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("clearBatch".equals(name)) {
            this._batchStatements.clear();
        } else if ("clearParameters".equals(name)) {
            this._parameters.clear();
        } else if (args != null && args.length > 0) {
            if ("execute".equals(name) || "executeQuery".equals(name) || "executeUpdate".equals(name)) {
                this._sqlStatement = (String)args[0];
            } else if ("addBatch".equals(name)) {
                this._batchStatements.add((String)args[0]);
            } else if (args[0] instanceof Integer) {
                if ("setNull".equals(name)) {
                    this._parameters.put(args[0], "null");
                } else if (SET_METHODS.contains(name)) {
                    this._parameters.put(args[0], args[1]);
                }
            }
        } else if ("toString".equals(name)) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(this._sqlStatement, "?");
            Iterator<Object> iter = new TreeSet<Object>(this._parameters.keySet()).iterator();
            while (tokenizer.hasMoreTokens()) {
                String partOfStatement = tokenizer.nextToken();
                if (iter.hasNext()) {
                    buffer.append(partOfStatement);
                    buffer.append("'");
                    buffer.append(this._parameters.get(iter.next()).toString());
                    buffer.append("'");
                    continue;
                }
                buffer.append(partOfStatement);
                buffer.append("?");
            }
            return buffer.toString();
        }
        return method.invoke((Object)this._callableStatement, args);
    }
}

