/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.castor.cpa.persistence.sql.driver.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class InterbaseQueryExpression
extends JDBCQueryExpression {
    private StringBuffer _sql;

    public InterbaseQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        Vector<String> done = new Vector<String>();
        this._sql = new StringBuffer();
        this._sql.append("SELECT ");
        if (this._distinct) {
            this._sql.append(" DISTINCT ");
        }
        this._sql.append(this.getColumnList());
        this._sql.append(" FROM ");
        Hashtable tables = new Hashtable(this._tables);
        boolean first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (done.contains(join._leftTable)) continue;
            if (first) {
                first = false;
                this._sql.append(this._factory.quoteName(join._leftTable));
            }
            this.appendJoin(join);
            tables.remove(join._leftTable);
            tables.remove(join._rightTable);
            for (int k = i + 1; k < this._joins.size(); ++k) {
                JDBCQueryExpression.Join join2 = (JDBCQueryExpression.Join)this._joins.elementAt(k);
                if (!join._leftTable.equals(join2._leftTable)) continue;
                this.appendJoin(join2);
                tables.remove(join2._rightTable);
            }
            done.addElement(join._leftTable);
        }
        Enumeration enumeration = tables.keys();
        while (enumeration.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                this._sql.append(",");
            }
            String tableAlias = (String)enumeration.nextElement();
            String tableName = (String)tables.get(tableAlias);
            if (tableAlias.equals(tableName)) {
                this._sql.append(this._factory.quoteName(tableName));
                continue;
            }
            this._sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        first = this.addWhereClause(this._sql, true);
        if (this._order != null) {
            this._sql.append(" ORDER BY ").append(this._order);
        }
        return this._sql.toString();
    }

    void appendJoin(JDBCQueryExpression.Join join) {
        if (join._outer) {
            this._sql.append(" LEFT OUTER JOIN ");
        } else {
            this._sql.append(" INNER JOIN ");
        }
        String tableAlias = join._rightTable;
        String tableName = (String)this._tables.get(tableAlias);
        if (tableAlias.equals(tableName)) {
            this._sql.append(this._factory.quoteName(tableName));
        } else {
            this._sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        this._sql.append(" ON ");
        for (int j = 0; j < join._leftColumns.length; ++j) {
            if (j > 0) {
                this._sql.append(" AND ");
            }
            this._sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j])).append("=");
            this._sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
        }
    }
}

