/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import org.castor.cpa.persistence.sql.driver.GenericFactory;
import org.castor.cpa.persistence.sql.driver.ReturnedRSCallQuery;
import org.castor.cpa.persistence.sql.driver.SapDbQueryExpression;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapDbFactory
extends GenericFactory {
    public static final String FACTORY_NAME = "sapdb";

    @Override
    public String getFactoryName() {
        return FACTORY_NAME;
    }

    @Override
    public QueryExpression getQueryExpression() {
        return new SapDbQueryExpression(this);
    }

    @Override
    public String quoteName(String name) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(name, ".");
        String token = null;
        boolean addQuote = true;
        buffer.append('\"');
        buffer.append(tokens.nextToken().toUpperCase());
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (this.isAFunction(token)) {
                addQuote = false;
                buffer.append("\".");
            } else {
                buffer.append("\".\"");
                token = token.toUpperCase();
            }
            buffer.append(token);
        }
        if (addQuote) {
            buffer.append('\"');
        }
        return buffer.toString();
    }

    private boolean isAFunction(String text) {
        boolean isAFunction = false;
        String[] knownFunctions = new String[]{"nextval", "currval"};
        for (int i = 0; i < knownFunctions.length; ++i) {
            String function = knownFunctions[i];
            if (!text.equals(function)) continue;
            return true;
        }
        return isAFunction;
    }

    @Override
    public PersistenceQuery getCallQuery(String call, Class<?>[] paramTypes, Class<?> javaClass, String[] fields, int[] sqlTypes) {
        return new ReturnedRSCallQuery(call, paramTypes, javaClass, fields, sqlTypes);
    }

    @Override
    public Class<?> adjustSqlType(Class<?> sqlType) {
        if (sqlType == Integer.class) {
            return BigDecimal.class;
        }
        return sqlType;
    }

    @Override
    public boolean isKeyGeneratorIdentitySupported() {
        return true;
    }

    @Override
    public boolean isKeyGeneratorIdentityTypeSupported(int type) {
        if (type == 4) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == 3) {
            return true;
        }
        return type == -5;
    }

    @Override
    public String getIdentitySelectString(String tableName, String columnName) {
        return "SELECT " + this.quoteName(tableName) + ".currval" + " FROM " + this.quoteName(tableName);
    }

    @Override
    public boolean isKeyGeneratorSequenceSupported(boolean returning, boolean trigger) {
        return !returning && !trigger;
    }

    @Override
    public boolean isKeyGeneratorSequenceTypeSupported(int type) {
        if (type == 4) {
            return true;
        }
        if (type == 3) {
            return true;
        }
        if (type == 2) {
            return true;
        }
        if (type == -5) {
            return true;
        }
        if (type == 1) {
            return true;
        }
        return type == 12;
    }

    @Override
    public String getSequenceBeforeSelectString(String seqName, String tableName, int increment) {
        return "SELECT " + this.quoteName(seqName + ".nextval") + " FROM DUAL";
    }
}

