/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.Enumeration;
import java.util.Vector;
import org.castor.cpa.persistence.sql.driver.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SapDbQueryExpression
extends JDBCQueryExpression {
    public SapDbQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        JDBCQueryExpression.Join join;
        Vector<String> sorted = new Vector<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        sql.append(this.getColumnList());
        sql.append(" FROM ");
        Enumeration joinEnumeration = this._joins.elements();
        while (joinEnumeration.hasMoreElements()) {
            join = (JDBCQueryExpression.Join)joinEnumeration.nextElement();
            if (!join._outer) continue;
            int left = sorted.indexOf(join._leftTable);
            int right = sorted.indexOf(join._rightTable);
            if (left >= 0 && right >= 0) {
                if (left <= right) continue;
                sorted.removeElement(join._leftTable);
                sorted.insertElementAt(join._leftTable, right);
                continue;
            }
            if (left < 0 && right >= 0) {
                sorted.insertElementAt(join._leftTable, right);
                continue;
            }
            if (left >= 0 && right < 0) {
                sorted.insertElementAt(join._rightTable, left + 1);
                continue;
            }
            sorted.addElement(join._leftTable);
            sorted.addElement(join._rightTable);
        }
        Enumeration tableEnumeration = this._tables.keys();
        while (tableEnumeration.hasMoreElements()) {
            String name = (String)tableEnumeration.nextElement();
            if (sorted.contains(name)) continue;
            sorted.addElement(name);
        }
        Enumeration sortedEnumeration = sorted.elements();
        while (sortedEnumeration.hasMoreElements()) {
            String tableName;
            String tableAlias = (String)sortedEnumeration.nextElement();
            if (tableAlias.equals(tableName = (String)this._tables.get(tableAlias))) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
            }
            if (!sortedEnumeration.hasMoreElements()) continue;
            sql.append(",");
        }
        boolean first = true;
        int size = this._joins.size();
        for (int i = 0; i < size; ++i) {
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            for (int j = 0; j < join._leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j]));
                sql.append("=");
                sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
                if (!join._outer) continue;
                sql.append("(+)");
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        if (this._limit != null) {
            if (this._distinct) {
                sql.insert(0, "SELECT * FROM (");
                sql.append(")");
            }
            sql.append(" LIMIT ");
            if (this._offset != null) {
                sql.append(this._offset).append(", ");
            }
            sql.append(this._limit);
        }
        if (lock) {
            sql.append(" WITH LOCK");
        }
        return sql.toString();
    }

    public boolean isLimitClauseSupported() {
        return true;
    }

    public boolean isOffsetClauseSupported() {
        return true;
    }
}

