/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.query.Delete;
import org.castor.cpa.persistence.sql.query.QueryContext;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SQLStatementDelete {
    private static final Log LOG = LogFactory.getLog(SQLStatementDelete.class);
    private static final ThreadLocal<PreparedStatement> PREPARED_STATEMENT = new ThreadLocal();
    private final String _type;
    private final SQLColumnInfo[] _ids;
    private final QueryContext _ctx;

    public SQLStatementDelete(SQLEngine engine, PersistenceFactory factory) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._ids = engine.getColumnInfoForIdentities();
        this._ctx = new QueryContext(factory);
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
    }

    private void buildStatement(String mapTo) {
        AndCondition condition = new AndCondition();
        for (int i = 0; i < this._ids.length; ++i) {
            String name = this._ids[i].getName();
            ((Condition)condition).and(new Column(name).equal(new Parameter(name)));
        }
        Delete delete = new Delete(mapTo);
        delete.setCondition(condition);
        delete.toString(this._ctx);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)this._ctx.toString()));
        }
    }

    public Object executeStatement(Connection conn, Identity identity) throws PersistenceException {
        try {
            try {
                this.prepareStatement(conn);
                this.bindIdentity(identity);
                this.executeStatement();
            }
            catch (SQLException ex) {
                LOG.fatal((Object)Messages.format((String)"jdo.deleteFatal", (Object)this._type, (Object)this._ctx.toString()), (Throwable)ex);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
            }
            Object var5_3 = null;
            this.closeStatement();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.closeStatement();
            throw throwable;
        }
        return null;
    }

    private void prepareStatement(Connection conn) throws SQLException {
        PreparedStatement preparedStatement = conn.prepareStatement(this._ctx.toString());
        PREPARED_STATEMENT.set(preparedStatement);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)preparedStatement.toString()));
        }
    }

    private void bindIdentity(Identity identity) throws SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        for (int i = 0; i < this._ids.length; ++i) {
            this._ctx.bindParameter(preparedStatement, this._ids[i].getName(), this._ids[i].toSQL(identity.get(i)), this._ids[i].getSqlType());
        }
    }

    private void executeStatement() throws SQLException {
        int result;
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.removing", (Object)this._type, (Object)preparedStatement.toString()));
        }
        if ((result = preparedStatement.executeUpdate()) < 1) {
            throw new SQLException("Object to be deleted does not exist!");
        }
    }

    private void closeStatement() {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)ex);
        }
    }
}

