/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.query.QueryContext;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SQLStatementInsertCheck {
    private static final Log LOG = LogFactory.getLog(SQLStatementInsertCheck.class);
    private static final ThreadLocal<PreparedStatement> PREPARED_STATEMENT = new ThreadLocal();
    private final String _type;
    private final SQLColumnInfo[] _ids;
    private final QueryContext _ctx;

    public SQLStatementInsertCheck(SQLEngine engine, PersistenceFactory factory) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._ids = engine.getColumnInfoForIdentities();
        this._ctx = new QueryContext(factory);
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
    }

    private void buildStatement(String mapTo) {
        Table table = new Table(mapTo);
        AndCondition condition = new AndCondition();
        for (int i = 0; i < this._ids.length; ++i) {
            ((Condition)condition).and(table.column(this._ids[i].getName()).equal(new Parameter(this._ids[i].getName())));
        }
        Select select = new Select(table);
        select.addSelect(table.column(this._ids[0].getName()));
        select.setCondition(condition);
        select.toString(this._ctx);
    }

    public void insertDuplicateKeyCheck(Connection conn, Identity identity) throws PersistenceException {
        try {
            try {
                if (identity == null) {
                    Object var5_3 = null;
                    this.closeStatement();
                    return;
                }
                this.prepareStatement(conn);
                this.bindIdentity(identity);
                ResultSet resultSet = this.executeQuery();
                if (resultSet.next()) {
                    this.closeStatement();
                    throw new DuplicateIdentityException(Messages.format((String)"persist.duplicateIdentity", (Object)this._type, (Object)identity));
                }
            }
            catch (SQLException except) {
                LOG.fatal((Object)Messages.format((String)"jdo.insertCheckFatal", (Object)this._type, (Object)this._ctx.toString()), (Throwable)except);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeStatement();
            throw throwable;
        }
        Object var5_4 = null;
        this.closeStatement();
    }

    private void prepareStatement(Connection conn) throws SQLException {
        PreparedStatement preparedStatement = conn.prepareStatement(this._ctx.toString());
        PREPARED_STATEMENT.set(preparedStatement);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.duplicateKeyCheck", (Object)this._ctx.toString()));
        }
    }

    private void bindIdentity(Identity identity) throws PersistenceException, SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        for (int i = 0; i < this._ids.length; ++i) {
            this._ctx.bindParameter(preparedStatement, this._ids[i].getName(), this._ids[i].toSQL(identity.get(i)), this._ids[i].getSqlType());
        }
    }

    private ResultSet executeQuery() throws SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        ResultSet result = preparedStatement.executeQuery();
        return result;
    }

    private void closeStatement() {
        try {
            PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException except2) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
        }
    }
}

