/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.SQLStatementUpdateCheck;
import org.castor.cpa.persistence.sql.query.QueryContext;
import org.castor.cpa.persistence.sql.query.Update;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SQLStatementUpdate {
    private static final Log LOG = LogFactory.getLog(SQLStatementUpdate.class);
    private static final String SET_PARAM_NAMESPACE = "SET:";
    private static final ThreadLocal<PreparedStatement> PREPARED_STATEMENT = new ThreadLocal();
    private final String _type;
    private final SQLColumnInfo[] _ids;
    private final SQLFieldInfo[] _fields;
    private final PersistenceFactory _factory;
    private Update _update;
    private boolean _hasFieldsToPersist;
    private final SQLStatementUpdateCheck _statementUpdateCheck;

    public SQLStatementUpdate(SQLEngine engine, PersistenceFactory factory) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._ids = engine.getColumnInfoForIdentities();
        this._fields = engine.getInfo();
        this._factory = factory;
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
        this._statementUpdateCheck = new SQLStatementUpdateCheck(engine, factory);
    }

    private void buildStatement(String mapTo) {
        this._update = new Update(mapTo);
        int count = 0;
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].isStore()) continue;
            SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                this._update.addAssignment(new Column(columns[j].getName()), new Parameter(SET_PARAM_NAMESPACE + columns[j].getName()));
                ++count;
            }
        }
        AndCondition condition = new AndCondition();
        for (int i = 0; i < this._ids.length; ++i) {
            String name = this._ids[i].getName();
            ((Condition)condition).and(new Column(name).equal(new Parameter(name)));
        }
        this._update.setCondition(condition);
        boolean bl = this._hasFieldsToPersist = count > 0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("hasFieldsToPersist = " + this._hasFieldsToPersist));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeStatement(Connection conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        if (this._hasFieldsToPersist) {
            QueryContext ctx = new QueryContext(this._factory);
            SQLStatementUpdate sQLStatementUpdate = this;
            synchronized (sQLStatementUpdate) {
                AndCondition copy = new AndCondition();
                ((Condition)copy).and(this._update.getCondition());
                try {
                    this.appendOldEntityCondition(oldentity);
                    this._update.toString(ctx);
                    Object var9_9 = null;
                    this._update.setCondition(copy);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this._update.setCondition(copy);
                    throw throwable;
                }
            }
            try {
                block10: {
                    try {
                        this.prepareStatement(conn, ctx);
                        this.bindNewEntity(newentity, ctx);
                        this.bindIdentity(identity, ctx);
                        this.bindOldEntity(oldentity, ctx);
                        if (this.executeStatement() > 0) break block10;
                        this._statementUpdateCheck.updateFailureCheck(conn, identity);
                    }
                    catch (SQLException ex) {
                        LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)ctx.toString()), (Throwable)ex);
                        throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
                    }
                }
                Object var12_13 = null;
                this.closeStatement();
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                this.closeStatement();
                throw throwable;
            }
        }
        return null;
    }

    private void appendOldEntityCondition(ProposedEntity oldentity) throws PersistenceException {
        Condition condition = this._update.getCondition();
        if (oldentity.getFields() != null) {
            for (int i = 0; i < this._fields.length; ++i) {
                int j;
                if (!this._fields[i].isStore() || !this._fields[i].isDirtyCheck()) continue;
                SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
                Object value = oldentity.getField(i);
                if (value == null) {
                    for (j = 0; j < columns.length; ++j) {
                        String name = columns[j].getName();
                        condition.and(new Column(name).isNull());
                    }
                    continue;
                }
                if (value instanceof Identity) {
                    Identity identity = (Identity)value;
                    if (identity.size() != columns.length) {
                        throw new PersistenceException("Size of identity field mismatch!");
                    }
                    for (int j2 = 0; j2 < columns.length; ++j2) {
                        String name = columns[j2].getName();
                        if (identity.get(j2) == null) {
                            condition.and(new Column(name).isNull());
                            continue;
                        }
                        condition.and(new Column(name).equal(new Parameter(name)));
                    }
                    continue;
                }
                for (j = 0; j < columns.length; ++j) {
                    String name = columns[j].getName();
                    condition.and(new Column(name).equal(new Parameter(name)));
                }
            }
        }
        this._update.setCondition(condition);
    }

    private void prepareStatement(Connection conn, QueryContext ctx) throws SQLException {
        PreparedStatement preparedStatement = conn.prepareStatement(ctx.toString());
        PREPARED_STATEMENT.set(preparedStatement);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)preparedStatement.toString()));
        }
    }

    private void bindNewEntity(ProposedEntity newentity, QueryContext ctx) throws PersistenceException, SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].isStore()) continue;
            SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
            Object value = newentity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    ctx.bindParameter(preparedStatement, SET_PARAM_NAMESPACE + columns[j].getName(), null, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity id = (Identity)value;
                if (id.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    ctx.bindParameter(preparedStatement, SET_PARAM_NAMESPACE + columns[j].getName(), columns[j].toSQL(id.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            ctx.bindParameter(preparedStatement, SET_PARAM_NAMESPACE + columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
        }
    }

    private void bindIdentity(Identity identity, QueryContext ctx) throws SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        for (int i = 0; i < this._ids.length; ++i) {
            ctx.bindParameter(preparedStatement, this._ids[i].getName(), this._ids[i].toSQL(identity.get(i)), this._ids[i].getSqlType());
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)this._ids[i].getName(), (Object)this._ids[i].toSQL(identity.get(i))));
        }
    }

    private void bindOldEntity(ProposedEntity oldentity, QueryContext ctx) throws PersistenceException, SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        if (oldentity.getFields() != null) {
            for (int i = 0; i < this._fields.length; ++i) {
                if (!this._fields[i].isStore() || !this._fields[i].isDirtyCheck()) continue;
                SQLColumnInfo[] columns = this._fields[i].getColumnInfo();
                Object value = oldentity.getField(i);
                if (value == null) continue;
                if (value instanceof Identity) {
                    Identity id = (Identity)value;
                    if (id.size() != columns.length) {
                        throw new PersistenceException("Size of identity field mismatch!");
                    }
                    for (int j = 0; j < columns.length; ++j) {
                        ctx.bindParameter(preparedStatement, columns[j].getName(), columns[j].toSQL(id.get(j)), columns[j].getSqlType());
                    }
                    continue;
                }
                if (columns.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                ctx.bindParameter(preparedStatement, columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)preparedStatement.toString()));
        }
    }

    private int executeStatement() throws SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        return preparedStatement.executeUpdate();
    }

    private void closeStatement() {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)ex);
        }
    }
}

