/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.query.QueryContext;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SQLStatementUpdateCheck {
    private static final Log LOG = LogFactory.getLog(SQLStatementUpdateCheck.class);
    private static final ThreadLocal<PreparedStatement> PREPARED_STATEMENT = new ThreadLocal();
    private final String _type;
    private final SQLColumnInfo[] _ids;
    private final QueryContext _ctx;

    public SQLStatementUpdateCheck(SQLEngine engine, PersistenceFactory factory) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._ids = engine.getColumnInfoForIdentities();
        this._ctx = new QueryContext(factory);
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
    }

    private void buildStatement(String mapTo) {
        Table table = new Table(mapTo);
        AndCondition condition = new AndCondition();
        for (int i = 0; i < this._ids.length; ++i) {
            ((Condition)condition).and(table.column(this._ids[i].getName()).equal(new Parameter(this._ids[i].getName())));
        }
        Select select = new Select(table);
        select.addSelect(table.column(this._ids[0].getName()));
        select.setCondition(condition);
        select.toString(this._ctx);
    }

    public void updateFailureCheck(Connection conn, Identity identity) throws PersistenceException {
        try {
            try {
                this.prepareStatement(conn);
                this.bindIdentity(identity);
                ResultSet resultSet = this.executeQuery();
                if (resultSet.next()) {
                    String msg = Messages.format((String)"persist.objectModified", (Object)this._type, (Object)identity);
                    throw new ObjectModifiedException(msg);
                }
                String msg = Messages.format((String)"persist.objectDeleted", (Object)this._type, (Object)identity);
                throw new ObjectDeletedException(msg);
            }
            catch (SQLException except) {
                LOG.fatal((Object)Messages.format((String)"jdo.updateCheckFatal", (Object)this._type, (Object)this._ctx.toString()), (Throwable)except);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeStatement();
            throw throwable;
        }
    }

    private void prepareStatement(Connection conn) throws SQLException {
        PreparedStatement preparedStatement = conn.prepareStatement(this._ctx.toString());
        PREPARED_STATEMENT.set(preparedStatement);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.updateCheck", (Object)this._type, (Object)preparedStatement.toString()));
        }
    }

    private void bindIdentity(Identity identity) throws SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        for (int i = 0; i < this._ids.length; ++i) {
            this._ctx.bindParameter(preparedStatement, this._ids[i].getName(), this._ids[i].toSQL(identity.get(i)), this._ids[i].getSqlType());
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)this._ids[i].getName(), (Object)this._ids[i].toSQL(identity.get(i))));
        }
    }

    private ResultSet executeQuery() throws SQLException {
        PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
        return preparedStatement.executeQuery();
    }

    private void closeStatement() {
        try {
            PreparedStatement preparedStatement = PREPARED_STATEMENT.get();
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)ex);
        }
    }
}

