/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.KeyGenerator;
import org.castor.jdo.engine.DatabaseContext;
import org.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;

public abstract class AbstractKeyGenerator
implements KeyGenerator {
    private static final Log LOG = LogFactory.getLog(AbstractKeyGenerator.class);

    public final Connection getSeparateConnection(Database database) throws PersistenceException {
        DatabaseContext context = null;
        try {
            context = DatabaseRegistry.getDatabaseContext(database.getDatabaseName());
        }
        catch (MappingException e) {
            throw new PersistenceException(Messages.message((String)"persist.cannotCreateSeparateConn"), e);
        }
        try {
            Connection conn = context.getConnectionFactory().createConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            throw new PersistenceException(Messages.message((String)"persist.cannotCreateSeparateConn"), e);
        }
    }

    public final void closeSeparateConnection(Connection conn) {
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

