/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractAfterKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandler;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerBigDecimal;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerInteger;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerLong;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerString;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class IdentityKeyGenerator
extends AbstractAfterKeyGenerator {
    private static final Log LOG = LogFactory.getLog(IdentityKeyGenerator.class);
    private static final int STRING_KEY_LENGTH = 8;
    private final PersistenceFactory _factory;
    private KeyGeneratorTypeHandler<? extends Object> _typeHandler;

    public IdentityKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        super(factory, null);
        this._factory = factory;
        if (!this._factory.isKeyGeneratorIdentitySupported()) {
            String msg = Messages.format((String)"mapping.keyGenNotCompatible", (Object)this.getClass().getName(), (Object)this._factory.getFactoryName());
            throw new MappingException(msg);
        }
        if (!this._factory.isKeyGeneratorIdentityTypeSupported(sqlType)) {
            String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType));
            throw new MappingException(msg);
        }
        this.initSqlTypeHandler(sqlType);
    }

    private void initSqlTypeHandler(int sqlType) {
        this._typeHandler = sqlType == 4 ? new KeyGeneratorTypeHandlerInteger(true) : (sqlType == -5 ? new KeyGeneratorTypeHandlerLong(true) : (sqlType == 1 || sqlType == 12 ? new KeyGeneratorTypeHandlerString(true, 8) : new KeyGeneratorTypeHandlerBigDecimal(true)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Object object;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = this._factory.getIdentitySelectString(tableName, primKeyName);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                object = this._typeHandler.getValue(rs);
                Object var10_11 = null;
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem generating new key", (Throwable)e);
                String msg = Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)e.toString());
                throw new PersistenceException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
            return object;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt == null) return object;
        stmt.close();
        return object;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

