/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandler;
import org.exolab.castor.jdo.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyGeneratorTypeHandlerBigDecimal
implements KeyGeneratorTypeHandler<BigDecimal> {
    private static final BigDecimal ZERO = new BigDecimal(0);
    private static final BigDecimal ONE = new BigDecimal(1);
    private final boolean _fail;

    public KeyGeneratorTypeHandlerBigDecimal(boolean fail) {
        this._fail = fail;
    }

    @Override
    public BigDecimal getNextValue(ResultSet rs) throws PersistenceException, SQLException {
        return this.increment(this.getValue(rs));
    }

    @Override
    public BigDecimal getValue(ResultSet rs) throws PersistenceException, SQLException {
        if (rs.next()) {
            BigDecimal value = rs.getBigDecimal(1);
            if (value == null) {
                value = ZERO;
            }
            return value;
        }
        if (!this._fail) {
            return ZERO;
        }
        String msg = Messages.format((String)"persist.keyGenFailed", (Object)"");
        throw new PersistenceException(msg);
    }

    @Override
    public BigDecimal increment(BigDecimal value) {
        return value.add(ONE);
    }

    @Override
    public BigDecimal add(BigDecimal value, int offset) {
        return value.add(new BigDecimal(offset));
    }

    @Override
    public void bindValue(PreparedStatement stmt, int index, BigDecimal value) throws SQLException {
        stmt.setBigDecimal(index, value);
    }
}

