/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandler;
import org.exolab.castor.jdo.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyGeneratorTypeHandlerLong
implements KeyGeneratorTypeHandler<Long> {
    private static final Long ZERO = new Long(0L);
    private final boolean _fail;

    public KeyGeneratorTypeHandlerLong(boolean fail) {
        this._fail = fail;
    }

    @Override
    public Long getNextValue(ResultSet rs) throws PersistenceException, SQLException {
        return this.increment(this.getValue(rs));
    }

    @Override
    public Long getValue(ResultSet rs) throws PersistenceException, SQLException {
        if (rs.next()) {
            return new Long(rs.getLong(1));
        }
        if (!this._fail) {
            return ZERO;
        }
        String msg = Messages.format((String)"persist.keyGenFailed", (Object)"");
        throw new PersistenceException(msg);
    }

    @Override
    public Long increment(Long value) {
        return new Long(value + 1L);
    }

    @Override
    public Long add(Long value, int offset) {
        return new Long(value + (long)offset);
    }

    @Override
    public void bindValue(PreparedStatement stmt, int index, Long value) throws SQLException {
        stmt.setLong(index, value);
    }
}

