/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractBeforeKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandler;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerBigDecimal;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerInteger;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerLong;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class MaxKeyGenerator
extends AbstractBeforeKeyGenerator {
    private static final Log LOG = LogFactory.getLog(MaxKeyGenerator.class);
    private final PersistenceFactory _factory;
    private KeyGeneratorTypeHandler<? extends Object> _typeHandler;

    public MaxKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        super(factory);
        this._factory = factory;
        if (sqlType != 4 && sqlType != -5 && sqlType != 2 && sqlType != 3) {
            String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType));
            throw new MappingException(msg);
        }
        this.initSqlTypeHandler(sqlType);
    }

    private void initSqlTypeHandler(int sqlType) {
        this._typeHandler = sqlType == 4 ? new KeyGeneratorTypeHandlerInteger(false) : (sqlType == -5 ? new KeyGeneratorTypeHandlerLong(false) : new KeyGeneratorTypeHandlerBigDecimal(false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Object object;
        PreparedStatement stmt = null;
        try {
            try {
                String sql = this.getQueryExpression(tableName, primKeyName);
                stmt = conn.prepareStatement(sql);
                ResultSet rs = stmt.executeQuery();
                object = this._typeHandler.getNextValue(rs);
                Object var10_10 = null;
                if (stmt == null) return object;
            }
            catch (SQLException ex) {
                throw new PersistenceException(Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)ex.toString()), ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException ex2) {
                LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)ex2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException ex2) {
            LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)ex2);
            return object;
        }
        stmt.close();
        return object;
    }

    private String getQueryExpression(String table, String column) throws QueryException {
        QueryExpression query = this._factory.getQueryExpression();
        query.addColumn(table, column);
        query.addCondition(table, column, "=", "(SELECT MAX(t1." + this._factory.quoteName(column) + ") FROM " + this._factory.quoteName(table) + " t1)");
        return query.getStatement(true);
    }

    public boolean isInSameConnection() {
        return true;
    }
}

