/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.SQLStatementInsertCheck;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGenerator;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.QueryContext;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class NoKeyGenerator
extends AbstractKeyGenerator {
    private static final Log LOG = LogFactory.getLog(NoKeyGenerator.class);
    private final PersistenceFactory _factory;
    private SQLEngine _engine;
    private String _mapTo;
    private String _engineType = null;
    private final QueryContext _ctx;

    public NoKeyGenerator(PersistenceFactory factory) {
        this._factory = factory;
        this._ctx = new QueryContext(this._factory);
    }

    public boolean isInSameConnection() {
        return true;
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        return null;
    }

    public KeyGenerator buildStatement(SQLEngine engine) {
        this._engine = engine;
        ClassDescriptor clsDesc = this._engine.getDescriptor();
        this._engineType = clsDesc.getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)clsDesc).getTableName();
        Insert insert = new Insert(this._mapTo);
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        for (int i = 0; i < ids.length; ++i) {
            String name = ids[i].getName();
            insert.addAssignment(new Column(name), new Parameter(name));
        }
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                String name = columns[j].getName();
                insert.addAssignment(new Column(name), new Parameter(name));
            }
        }
        insert.toString(this._ctx);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)this._ctx.toString()));
        }
        return this;
    }

    public Object executeStatement(Database database, Connection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        SQLStatementInsertCheck lookupStatement = new SQLStatementInsertCheck(this._engine, this._factory);
        Identity internalIdentity = identity;
        SQLEngine extended = this._engine.getExtends();
        if (extended == null && internalIdentity == null) {
            throw new PersistenceException(Messages.format((String)"persist.noIdentity", (Object)this._engineType));
        }
        PreparedStatement stmt = null;
        try {
            ClassDescriptor extDesc;
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                internalIdentity = extended.create(database, conn, entity, internalIdentity);
            }
            stmt = conn.prepareStatement(this._ctx.toString());
            this.bindIdentity(internalIdentity, stmt);
            this.bindFields(entity, stmt);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            stmt.close();
            return internalIdentity;
        }
        catch (SQLException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._engineType, (Object)this._ctx.toString()), (Throwable)except);
            lookupStatement.insertDuplicateKeyCheck(conn, internalIdentity);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
    }

    public void bindIdentity(Identity internalIdentity, PreparedStatement stmt) throws SQLException, PersistenceException {
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        if (internalIdentity.size() != ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        for (int i = 0; i < ids.length; ++i) {
            this._ctx.bindParameter(stmt, ids[i].getName(), ids[i].toSQL(internalIdentity.get(i)), ids[i].getSqlType());
        }
    }

    private void bindFields(ProposedEntity entity, PreparedStatement stmt) throws SQLException, PersistenceException {
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            if (!fields[i].isStore()) continue;
            Object value = entity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    this._ctx.bindParameter(stmt, columns[j].getName(), null, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity identity = (Identity)value;
                if (identity.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    this._ctx.bindParameter(stmt, columns[j].getName(), columns[j].toSQL(identity.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            this._ctx.bindParameter(stmt, columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
        }
    }
}

