/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractAfterKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandler;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerBigDecimal;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerInteger;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerLong;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorTypeHandlerString;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SequenceAfterKeyGenerator
extends AbstractAfterKeyGenerator {
    private static final Log LOG = LogFactory.getLog(SequenceAfterKeyGenerator.class);
    private static final int STRING_KEY_LENGTH = 8;
    private PersistenceFactory _factory;
    private String _seqName;
    private KeyGeneratorTypeHandler<? extends Object> _typeHandler;

    public SequenceAfterKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        super(factory, params);
        this._factory = factory;
        this._seqName = params.getProperty("sequence", "{0}_seq");
        this.initSqlTypeHandler(sqlType);
    }

    protected void initSqlTypeHandler(int sqlType) {
        this._typeHandler = sqlType == 4 ? new KeyGeneratorTypeHandlerInteger(true) : (sqlType == -5 ? new KeyGeneratorTypeHandlerLong(true) : (sqlType == 1 || sqlType == 12 ? new KeyGeneratorTypeHandlerString(true, 8) : new KeyGeneratorTypeHandlerBigDecimal(true)));
    }

    private String getSeqName(String tableName, String primKeyName) {
        return MessageFormat.format(this._seqName, tableName, primKeyName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Object object;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = this._factory.getSequenceAfterSelectString(this.getSeqName(tableName, primKeyName), tableName);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                object = this._typeHandler.getValue(rs);
                Object var10_11 = null;
            }
            catch (SQLException e) {
                String msg = Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)e.toString());
                throw new PersistenceException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e2);
            return object;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt == null) return object;
        stmt.close();
        return object;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

