/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.util.Properties;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.KeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorFactory;
import org.castor.cpa.persistence.sql.keygen.SequenceAfterKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.SequenceBeforeKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.SequenceDuringKeyGenerator;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class SequenceKeyGeneratorFactory
implements KeyGeneratorFactory {
    public String getKeyGeneratorName() {
        return "SEQUENCE";
    }

    public KeyGenerator getKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        boolean trigger;
        String factoryName = factory.getFactoryName();
        boolean returning = "true".equals(params.getProperty("returning"));
        if (!factory.isKeyGeneratorSequenceSupported(returning, trigger = "true".equals(params.getProperty("trigger", "false")))) {
            String msg = Messages.format((String)"mapping.keyGenNotCompatible", (Object)this.getClass().getName(), (Object)factory.getFactoryName());
            throw new MappingException(msg);
        }
        if (!factory.isKeyGeneratorSequenceTypeSupported(sqlType)) {
            String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType));
            throw new MappingException(msg);
        }
        if (returning) {
            if ("postgresql".equals(factoryName)) {
                return new SequenceBeforeKeyGenerator(factory, params, sqlType);
            }
            return new SequenceDuringKeyGenerator(factory, params, sqlType);
        }
        if (trigger) {
            return new SequenceAfterKeyGenerator(factory, params, sqlType);
        }
        return new SequenceBeforeKeyGenerator(factory, params, sqlType);
    }
}

