/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.net.InetAddress;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractBeforeKeyGenerator;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class UUIDKeyGenerator
extends AbstractBeforeKeyGenerator {
    private static final DecimalFormat IP_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("0000000000000");
    private static final DecimalFormat COUNTER_FORMAT = new DecimalFormat("00000");
    private static final long COUNTER_MAX = 99999L;
    private static long _staticCounter = 0L;
    private String _hostAddress;

    public UUIDKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        super(factory);
        if (sqlType != 1 && sqlType != 12 && sqlType != -1) {
            String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType));
            throw new MappingException(msg);
        }
        this.initHostAddress();
    }

    private void initHostAddress() throws MappingException {
        try {
            String host = InetAddress.getLocalHost().getHostAddress();
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(host, ".");
            while (st.hasMoreTokens()) {
                sb.append(IP_FORMAT.format(new Integer(st.nextToken())));
            }
            this._hostAddress = sb.toString();
        }
        catch (Exception ex) {
            throw new MappingException(Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)ex.toString()), ex);
        }
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        StringBuffer sb = new StringBuffer();
        sb.append(this._hostAddress);
        sb.append(TIME_FORMAT.format(System.currentTimeMillis()));
        if (_staticCounter >= 99999L) {
            _staticCounter = 0L;
        }
        sb.append(COUNTER_FORMAT.format(++_staticCounter));
        return sb.toString();
    }

    public boolean isInSameConnection() {
        return true;
    }
}

