/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.SQLTypeInfos;
import org.exolab.castor.persist.spi.PersistenceFactory;

public class QueryContext {
    private static final Log LOG = LogFactory.getLog(QueryContext.class);
    private final PersistenceFactory _factory;
    private final StringBuilder _builder = new StringBuilder();
    private final Map<String, Integer> _parameters = new HashMap<String, Integer>();

    public QueryContext() {
        this(null);
    }

    public QueryContext(PersistenceFactory factory) {
        this._factory = factory;
    }

    public String quoteName(String name) {
        if (this._factory == null) {
            return name;
        }
        return this._factory.quoteName(name);
    }

    public String getSequenceNextValString(String seqName) {
        if (this._factory == null) {
            return seqName + ".nextval";
        }
        return this._factory.getSequenceNextValString(seqName);
    }

    public final QueryContext append(char chr) {
        this._builder.append(chr);
        return this;
    }

    public final QueryContext append(String str) {
        this._builder.append(str);
        return this;
    }

    public final String toString() {
        return this._builder.toString();
    }

    public final void addParameter(String name) {
        this._parameters.put(name, this._parameters.size() + 1);
    }

    public final void bindParameter(PreparedStatement stmt, String name, Object value, int type) throws SQLException {
        Integer index = this._parameters.get(name);
        if (index != null) {
            SQLTypeInfos.setValue(stmt, index, value, type);
        } else {
            LOG.debug((Object)("Unknown parameter: " + name));
        }
    }

    public final int parameterSize() {
        return this._parameters.size();
    }
}

