/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.QueryContext;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Expression;

public final class Select
extends QueryObject {
    private final Qualifier _qualifier;
    private final List<Expression> _select = new ArrayList<Expression>();
    private Condition _condition;

    public Select(String name) {
        this(new Table(name));
    }

    public Select(Qualifier qualifier) {
        if (qualifier == null) {
            throw new NullPointerException();
        }
        this._qualifier = qualifier;
    }

    public void addSelect(Column name) {
        this._select.add(name);
    }

    public Condition getCondition() {
        return this._condition;
    }

    public void setCondition(Condition condition) {
        this._condition = condition;
    }

    public void toString(QueryContext ctx) {
        ctx.append("SELECT");
        ctx.append(' ');
        if (this._select.isEmpty()) {
            ctx.append('*');
        } else {
            Iterator<Expression> iter = this._select.iterator();
            while (iter.hasNext()) {
                iter.next().toString(ctx);
                if (!iter.hasNext()) continue;
                ctx.append(',');
                ctx.append(' ');
            }
        }
        ctx.append(' ');
        ctx.append("FROM");
        ctx.append(' ');
        this._qualifier.toString(ctx);
        if (this._condition != null) {
            ctx.append(' ');
            ctx.append("WHERE");
            ctx.append(' ');
            this._condition.toString(ctx);
        }
    }
}

