/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.object.expression;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.castor.cpa.query.Condition;
import org.castor.cpa.query.Expression;
import org.castor.cpa.query.Function;
import org.castor.cpa.query.Parameter;
import org.castor.cpa.query.TemporalType;
import org.castor.cpa.query.TrimSpecification;
import org.castor.cpa.query.object.AbstractQueryObject;
import org.castor.cpa.query.object.condition.Between;
import org.castor.cpa.query.object.condition.Comparison;
import org.castor.cpa.query.object.condition.Like;
import org.castor.cpa.query.object.expression.Add;
import org.castor.cpa.query.object.expression.Concat;
import org.castor.cpa.query.object.expression.Divide;
import org.castor.cpa.query.object.expression.Multiply;
import org.castor.cpa.query.object.expression.Negate;
import org.castor.cpa.query.object.expression.Remainder;
import org.castor.cpa.query.object.expression.Subtract;
import org.castor.cpa.query.object.function.Abs;
import org.castor.cpa.query.object.function.Length;
import org.castor.cpa.query.object.function.Locate;
import org.castor.cpa.query.object.function.Lower;
import org.castor.cpa.query.object.function.Sqrt;
import org.castor.cpa.query.object.function.Substring;
import org.castor.cpa.query.object.function.Trim;
import org.castor.cpa.query.object.function.Upper;
import org.castor.cpa.query.object.literal.AbstractTemporalLiteral;
import org.castor.cpa.query.object.literal.BigDecimalLiteral;
import org.castor.cpa.query.object.literal.BooleanLiteral;
import org.castor.cpa.query.object.literal.DoubleLiteral;
import org.castor.cpa.query.object.literal.LongLiteral;
import org.castor.cpa.query.object.literal.StringLiteral;

public abstract class AbstractExpression
extends AbstractQueryObject
implements Expression {
    public final Expression add(long value) {
        return this.add(new LongLiteral(value));
    }

    public final Expression add(double value) {
        return this.add(new DoubleLiteral(value));
    }

    public final Expression add(BigDecimal value) {
        return this.add(new BigDecimalLiteral(value));
    }

    public Expression add(Expression expression) {
        Add add = new Add();
        add.addExpression(this);
        add.addExpression(expression);
        return add;
    }

    public final Expression subtract(long value) {
        return this.subtract(new LongLiteral(value));
    }

    public final Expression subtract(double value) {
        return this.subtract(new DoubleLiteral(value));
    }

    public final Expression subtract(BigDecimal value) {
        return this.subtract(new BigDecimalLiteral(value));
    }

    public Expression subtract(Expression expression) {
        Subtract subtract = new Subtract();
        subtract.addExpression(this);
        subtract.addExpression(expression);
        return subtract;
    }

    public final Expression concat(String value) {
        return this.concat(new StringLiteral(value));
    }

    public Expression concat(Expression expression) {
        Concat concat = new Concat();
        concat.addExpression(this);
        concat.addExpression(expression);
        return concat;
    }

    public final Expression multiply(long value) {
        return this.multiply(new LongLiteral(value));
    }

    public final Expression multiply(double value) {
        return this.multiply(new DoubleLiteral(value));
    }

    public final Expression multiply(BigDecimal value) {
        return this.multiply(new BigDecimalLiteral(value));
    }

    public Expression multiply(Expression expression) {
        Multiply multiply = new Multiply();
        multiply.addExpression(this);
        multiply.addExpression(expression);
        return multiply;
    }

    public final Expression divide(long value) {
        return this.divide(new LongLiteral(value));
    }

    public final Expression divide(double value) {
        return this.divide(new DoubleLiteral(value));
    }

    public final Expression divide(BigDecimal value) {
        return this.divide(new BigDecimalLiteral(value));
    }

    public Expression divide(Expression expression) {
        Divide divide = new Divide();
        divide.addExpression(this);
        divide.addExpression(expression);
        return divide;
    }

    public final Expression remainder(long value) {
        return this.remainder(new LongLiteral(value));
    }

    public final Expression remainder(double value) {
        return this.remainder(new DoubleLiteral(value));
    }

    public final Expression remainder(BigDecimal value) {
        return this.remainder(new BigDecimalLiteral(value));
    }

    public Expression remainder(Expression expression) {
        Remainder remainder = new Remainder();
        remainder.addExpression(this);
        remainder.addExpression(expression);
        return remainder;
    }

    public final Expression plus() {
        return this;
    }

    public Expression negate() {
        Negate negate = new Negate();
        negate.setExpression(this);
        return negate;
    }

    public final Function length() {
        Length length = new Length();
        length.setString(this);
        return length;
    }

    public final Function abs() {
        Abs abs = new Abs();
        abs.setNumber(this);
        return abs;
    }

    public final Function sqrt() {
        Sqrt sqrt = new Sqrt();
        sqrt.setNumber(this);
        return sqrt;
    }

    public final Function lower() {
        Lower lower = new Lower();
        lower.setString(this);
        return lower;
    }

    public final Function upper() {
        Upper upper = new Upper();
        upper.setString(this);
        return upper;
    }

    public final Function locate(String value) {
        return this.locate(new StringLiteral(value));
    }

    public final Function locate(Expression value) {
        Locate locate = new Locate();
        locate.setString(this);
        locate.setValue(value);
        return locate;
    }

    public final Function locate(String value, int index) {
        return this.locate((Expression)new StringLiteral(value), (Expression)new LongLiteral(index));
    }

    public final Function locate(String value, Expression index) {
        return this.locate((Expression)new StringLiteral(value), index);
    }

    public final Function locate(Expression value, int index) {
        return this.locate(value, (Expression)new LongLiteral(index));
    }

    public final Function locate(Expression value, Expression index) {
        Locate locate = new Locate();
        locate.setString(this);
        locate.setValue(value);
        locate.setIndex(index);
        return locate;
    }

    public final Function substring(int index, int length) {
        return this.substring((Expression)new LongLiteral(index), (Expression)new LongLiteral(length));
    }

    public final Function substring(int index, Expression length) {
        return this.substring((Expression)new LongLiteral(index), length);
    }

    public final Function substring(Expression index, int length) {
        return this.substring(index, (Expression)new LongLiteral(length));
    }

    public final Function substring(Expression index, Expression length) {
        Substring substring = new Substring();
        substring.setString(this);
        substring.setIndex(index);
        substring.setLength(length);
        return substring;
    }

    public final Function trim() {
        Trim trim = new Trim();
        trim.setString(this);
        return trim;
    }

    public final Function trim(char character) {
        Trim trim = new Trim();
        trim.setString(this);
        trim.setCharacter(new StringLiteral(Character.toString(character)));
        return trim;
    }

    public final Function trim(Parameter character) {
        Trim trim = new Trim();
        trim.setString(this);
        trim.setCharacter(character);
        return trim;
    }

    public final Function trim(TrimSpecification trimSpecification) {
        Trim trim = new Trim();
        trim.setString(this);
        trim.setSpecification(trimSpecification);
        return trim;
    }

    public final Function trim(TrimSpecification trimSpecification, char character) {
        Trim trim = new Trim();
        trim.setString(this);
        trim.setSpecification(trimSpecification);
        trim.setCharacter(new StringLiteral(Character.toString(character)));
        return trim;
    }

    public final Function trim(TrimSpecification trimSpecification, Parameter character) {
        Trim trim = new Trim();
        trim.setString(this);
        trim.setSpecification(trimSpecification);
        trim.setCharacter(character);
        return trim;
    }

    public final Condition equal(boolean value) {
        return this.equal(new BooleanLiteral(value));
    }

    public final Condition equal(long value) {
        return this.equal(new LongLiteral(value));
    }

    public final Condition equal(double value) {
        return this.equal(new DoubleLiteral(value));
    }

    public final Condition equal(BigDecimal value) {
        return this.equal(new BigDecimalLiteral(value));
    }

    public final Condition equal(String value) {
        return this.equal(new StringLiteral(value));
    }

    public final Condition equal(TemporalType temporalType, Date value) {
        return this.equal(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition equal(TemporalType temporalType, Calendar value) {
        return this.equal(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition equal(Expression value) {
        Comparison comp = new Comparison(Comparison.EQUAL);
        comp.setLeftSide(this);
        comp.setRightSide(value);
        return comp;
    }

    public final Condition notEqual(boolean value) {
        return this.notEqual(new BooleanLiteral(value));
    }

    public final Condition notEqual(long value) {
        return this.notEqual(new LongLiteral(value));
    }

    public final Condition notEqual(double value) {
        return this.notEqual(new DoubleLiteral(value));
    }

    public final Condition notEqual(BigDecimal value) {
        return this.notEqual(new BigDecimalLiteral(value));
    }

    public final Condition notEqual(String value) {
        return this.notEqual(new StringLiteral(value));
    }

    public final Condition notEqual(TemporalType temporalType, Date value) {
        return this.notEqual(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition notEqual(TemporalType temporalType, Calendar value) {
        return this.notEqual(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition notEqual(Expression value) {
        Comparison comp = new Comparison(Comparison.NOT_EQUAL);
        comp.setLeftSide(this);
        comp.setRightSide(value);
        return comp;
    }

    public final Condition lessThan(long value) {
        return this.lessThan(new LongLiteral(value));
    }

    public final Condition lessThan(double value) {
        return this.lessThan(new DoubleLiteral(value));
    }

    public final Condition lessThan(BigDecimal value) {
        return this.lessThan(new BigDecimalLiteral(value));
    }

    public final Condition lessThan(String value) {
        return this.lessThan(new StringLiteral(value));
    }

    public final Condition lessThan(TemporalType temporalType, Date value) {
        return this.lessThan(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition lessThan(TemporalType temporalType, Calendar value) {
        return this.lessThan(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition lessThan(Expression value) {
        Comparison comp = new Comparison(Comparison.LESS_THAN);
        comp.setLeftSide(this);
        comp.setRightSide(value);
        return comp;
    }

    public final Condition lessEqual(long value) {
        return this.lessEqual(new LongLiteral(value));
    }

    public final Condition lessEqual(double value) {
        return this.lessEqual(new DoubleLiteral(value));
    }

    public final Condition lessEqual(BigDecimal value) {
        return this.lessEqual(new BigDecimalLiteral(value));
    }

    public final Condition lessEqual(String value) {
        return this.lessEqual(new StringLiteral(value));
    }

    public final Condition lessEqual(TemporalType temporalType, Date value) {
        return this.lessEqual(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition lessEqual(TemporalType temporalType, Calendar value) {
        return this.lessEqual(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition lessEqual(Expression value) {
        Comparison comp = new Comparison(Comparison.LESS_EQUAL);
        comp.setLeftSide(this);
        comp.setRightSide(value);
        return comp;
    }

    public final Condition greaterEqual(long value) {
        return this.greaterEqual(new LongLiteral(value));
    }

    public final Condition greaterEqual(double value) {
        return this.greaterEqual(new DoubleLiteral(value));
    }

    public final Condition greaterEqual(BigDecimal value) {
        return this.greaterEqual(new BigDecimalLiteral(value));
    }

    public final Condition greaterEqual(String value) {
        return this.greaterEqual(new StringLiteral(value));
    }

    public final Condition greaterEqual(TemporalType temporalType, Date value) {
        return this.greaterEqual(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition greaterEqual(TemporalType temporalType, Calendar value) {
        return this.greaterEqual(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition greaterEqual(Expression value) {
        Comparison comp = new Comparison(Comparison.GREATER_EQUAL);
        comp.setLeftSide(this);
        comp.setRightSide(value);
        return comp;
    }

    public final Condition greaterThan(long value) {
        return this.greaterThan(new LongLiteral(value));
    }

    public final Condition greaterThan(double value) {
        return this.greaterThan(new DoubleLiteral(value));
    }

    public final Condition greaterThan(BigDecimal value) {
        return this.greaterThan(new BigDecimalLiteral(value));
    }

    public final Condition greaterThan(String value) {
        return this.greaterThan(new StringLiteral(value));
    }

    public final Condition greaterThan(TemporalType temporalType, Date value) {
        return this.greaterThan(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition greaterThan(TemporalType temporalType, Calendar value) {
        return this.greaterThan(AbstractTemporalLiteral.createInstance(temporalType, value));
    }

    public final Condition greaterThan(Expression value) {
        Comparison comp = new Comparison(Comparison.GREATER_THAN);
        comp.setLeftSide(this);
        comp.setRightSide(value);
        return comp;
    }

    public final Condition like(String pattern) {
        Like like = new Like();
        like.setNot(false);
        like.setExpression(this);
        like.setPattern(new StringLiteral(pattern));
        return like;
    }

    public final Condition like(Parameter pattern) {
        Like like = new Like();
        like.setNot(false);
        like.setExpression(this);
        like.setPattern(pattern);
        return like;
    }

    public final Condition like(String pattern, char escape) {
        Like like = new Like();
        like.setNot(false);
        like.setExpression(this);
        like.setPattern(new StringLiteral(pattern));
        like.setEscape(new StringLiteral(Character.toString(escape)));
        return like;
    }

    public final Condition like(String pattern, Parameter escape) {
        Like like = new Like();
        like.setNot(false);
        like.setExpression(this);
        like.setPattern(new StringLiteral(pattern));
        like.setEscape(escape);
        return like;
    }

    public final Condition like(Parameter pattern, char escape) {
        Like like = new Like();
        like.setNot(false);
        like.setExpression(this);
        like.setPattern(pattern);
        like.setEscape(new StringLiteral(Character.toString(escape)));
        return like;
    }

    public final Condition like(Parameter pattern, Parameter escape) {
        Like like = new Like();
        like.setNot(false);
        like.setExpression(this);
        like.setPattern(pattern);
        like.setEscape(escape);
        return like;
    }

    public final Condition notLike(String pattern) {
        Like like = new Like();
        like.setNot(true);
        like.setExpression(this);
        like.setPattern(new StringLiteral(pattern));
        return like;
    }

    public final Condition notLike(String pattern, char escape) {
        Like like = new Like();
        like.setNot(true);
        like.setExpression(this);
        like.setPattern(new StringLiteral(pattern));
        like.setEscape(new StringLiteral(Character.toString(escape)));
        return like;
    }

    public final Condition notLike(String pattern, Parameter escape) {
        Like like = new Like();
        like.setNot(true);
        like.setExpression(this);
        like.setPattern(new StringLiteral(pattern));
        like.setEscape(escape);
        return like;
    }

    public final Condition notLike(Parameter pattern) {
        Like like = new Like();
        like.setNot(true);
        like.setExpression(this);
        like.setPattern(pattern);
        return like;
    }

    public final Condition notLike(Parameter pattern, char escape) {
        Like like = new Like();
        like.setNot(true);
        like.setExpression(this);
        like.setPattern(pattern);
        like.setEscape(new StringLiteral(Character.toString(escape)));
        return like;
    }

    public final Condition notLike(Parameter pattern, Parameter escape) {
        Like like = new Like();
        like.setNot(true);
        like.setExpression(this);
        like.setPattern(pattern);
        like.setEscape(escape);
        return like;
    }

    public final Condition between(long low, long high) {
        return this.between(new LongLiteral(low), new LongLiteral(high));
    }

    public final Condition between(double low, double high) {
        return this.between(new DoubleLiteral(low), new DoubleLiteral(high));
    }

    public final Condition between(BigDecimal low, BigDecimal high) {
        return this.between(new BigDecimalLiteral(low), new BigDecimalLiteral(high));
    }

    public final Condition between(String low, String high) {
        return this.between(new StringLiteral(low), new StringLiteral(high));
    }

    public final Condition between(TemporalType temporalType, Date low, Date high) {
        return this.between(AbstractTemporalLiteral.createInstance(temporalType, low), AbstractTemporalLiteral.createInstance(temporalType, high));
    }

    public final Condition between(TemporalType temporalType, Calendar low, Calendar high) {
        return this.between(AbstractTemporalLiteral.createInstance(temporalType, low), AbstractTemporalLiteral.createInstance(temporalType, high));
    }

    public final Condition between(Expression low, Expression high) {
        Between between = new Between();
        between.setNot(false);
        between.setExpression(this);
        between.setLow(low);
        between.setHigh(high);
        return between;
    }

    public final Condition notBetween(long low, long high) {
        return this.notBetween(new LongLiteral(low), new LongLiteral(high));
    }

    public final Condition notBetween(double low, double high) {
        return this.notBetween(new DoubleLiteral(low), new DoubleLiteral(high));
    }

    public final Condition notBetween(BigDecimal low, BigDecimal high) {
        return this.notBetween(new BigDecimalLiteral(low), new BigDecimalLiteral(high));
    }

    public final Condition notBetween(String low, String high) {
        return this.notBetween(new StringLiteral(low), new StringLiteral(high));
    }

    public final Condition notBetween(TemporalType temporalType, Date low, Date high) {
        return this.notBetween(AbstractTemporalLiteral.createInstance(temporalType, low), AbstractTemporalLiteral.createInstance(temporalType, high));
    }

    public final Condition notBetween(TemporalType temporalType, Calendar low, Calendar high) {
        return this.notBetween(AbstractTemporalLiteral.createInstance(temporalType, low), AbstractTemporalLiteral.createInstance(temporalType, high));
    }

    public final Condition notBetween(Expression low, Expression high) {
        Between between = new Between();
        between.setNot(true);
        between.setExpression(this);
        between.setLow(low);
        between.setHigh(high);
        return between;
    }
}

