/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.object.function;

import java.math.BigDecimal;
import org.castor.cpa.query.Expression;
import org.castor.cpa.query.object.function.AbstractFunction;
import org.castor.cpa.query.object.literal.BigDecimalLiteral;
import org.castor.cpa.query.object.literal.DoubleLiteral;
import org.castor.cpa.query.object.literal.LongLiteral;

public final class Locate
extends AbstractFunction {
    private static final double OFFSET = 1.0E-10;
    private Expression _string;
    private Expression _value;
    private Expression _index = new LongLiteral(1L);

    public Expression getString() {
        return this._string;
    }

    public void setString(Expression string) {
        this._string = string;
    }

    public Expression getValue() {
        return this._value;
    }

    public void setValue(Expression value) {
        this._value = value;
    }

    public Expression getIndex() {
        return this._index;
    }

    public void setIndex(Expression index) {
        this._index = index;
    }

    public StringBuilder toString(StringBuilder sb) {
        boolean defaultStart = false;
        if (this._index instanceof LongLiteral) {
            LongLiteral literal = (LongLiteral)this._index;
            defaultStart = literal.getValue() == 1L;
        } else if (this._index instanceof DoubleLiteral) {
            DoubleLiteral literal = (DoubleLiteral)this._index;
            defaultStart = Math.abs(literal.getValue() - 1.0) < 1.0E-10;
        } else if (this._index instanceof BigDecimalLiteral) {
            BigDecimalLiteral literal = (BigDecimalLiteral)this._index;
            BigDecimal value = literal.getValue();
            BigDecimal diff = value.subtract(new BigDecimal(1.0)).abs();
            defaultStart = diff.compareTo(new BigDecimal(1.0E-10)) < 0;
        }
        sb.append("LOCATE(");
        if (this._string != null) {
            this._string.toString(sb);
        }
        sb.append(", ");
        if (this._value != null) {
            this._value.toString(sb);
        }
        if (!defaultStart) {
            sb.append(", ");
            if (this._index != null) {
                this._index.toString(sb);
            }
        }
        return sb.append(')');
    }
}

