/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.object.literal;

import org.castor.cpa.query.object.literal.AbstractLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumLiteral
extends AbstractLiteral {
    private final Enum<?> _value;

    public EnumLiteral(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int dot = value.lastIndexOf(46);
        if (dot < 0) {
            throw new IllegalArgumentException();
        }
        Class<?> type = null;
        try {
            String typename = value.substring(0, dot);
            type = Class.forName(typename);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException();
        }
        if (!type.isEnum()) {
            throw new IllegalArgumentException();
        }
        ?[] enumvalues = type.getEnumConstants();
        String enumname = value.substring(dot + 1);
        Enum enumvalue = null;
        for (int i = 0; i < enumvalues.length; ++i) {
            if (!enumname.equals(enumvalues[i].toString())) continue;
            enumvalue = (Enum)enumvalues[i];
        }
        if (enumvalue == null) {
            throw new IllegalArgumentException();
        }
        this._value = enumvalue;
    }

    public EnumLiteral(Enum<?> value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this._value = value;
    }

    public Enum<?> getValue() {
        return this._value;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return sb.append(this._value.getClass().getName()).append('.').append(this._value);
    }
}

