/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.util.classresolution.command;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cpa.util.classresolution.command.BaseResolutionCommand;
import org.castor.jdo.jpa.info.ClassInfo;
import org.castor.jdo.jpa.info.ClassInfoBuilder;
import org.castor.jdo.jpa.info.InfoToDescriptorConverter;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;

public class ClassResolutionByAnnotations
extends BaseResolutionCommand {
    private static final Log LOG = LogFactory.getLog(ClassResolutionByAnnotations.class);
    private Map<Class<?>, ClassDescriptorImpl> _loopCache = new LinkedHashMap();

    public ClassDescriptor resolve(Class type) {
        if (this._loopCache.containsKey(type)) {
            return (ClassDescriptor)this._loopCache.get(type);
        }
        ClassInfo buildClassInfo = null;
        try {
            buildClassInfo = ClassInfoBuilder.buildClassInfo(type);
            if (buildClassInfo == null) {
                return null;
            }
        }
        catch (MappingException e1) {
            LOG.error((Object)e1.getMessage());
            return null;
        }
        ClassDescriptorImpl classDesc = new ClassDescriptorImpl();
        this._loopCache.put(type, classDesc);
        try {
            InfoToDescriptorConverter.convert(buildClassInfo, this.getClassDescriptorResolver(), classDesc);
            this._loopCache.remove(type);
            return classDesc;
        }
        catch (MappingException e) {
            LOG.error((Object)e.getMessage());
            this._loopCache.remove(type);
            return null;
        }
    }
}

