/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Enumeration;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.cpa.persistence.sql.connection.ConnectionFactory;
import org.castor.cpa.util.JDOClassDescriptorResolver;
import org.castor.cpa.util.JDOClassDescriptorResolverImpl;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.conf.Mapping;
import org.castor.jdo.util.JDOConfAdapter;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerRegistry;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceEngineFactory;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class DatabaseContext {
    public static final String GENERIC_ENGINE = "generic";
    private static final Log LOG = LogFactory.getLog(DatabaseContext.class);
    private boolean _initialized = false;
    private JdoConf _jdoConf;
    private int _index;
    private String _name;
    private org.exolab.castor.mapping.Mapping _mapping;
    private TransactionManager _txManager;
    private LockEngine _engine = null;
    private JDOClassDescriptorResolver _classDescriptorResolver = null;
    private ConnectionFactory _factory;

    protected DatabaseContext(String name, String engine, org.exolab.castor.mapping.Mapping mapping, TransactionManager txManager, ConnectionFactory factory) throws MappingException {
        this._jdoConf = null;
        this._index = -1;
        this._name = name;
        this._mapping = mapping;
        this._txManager = txManager;
        this._factory = factory;
        this.initializeEngine(engine);
        this._initialized = true;
    }

    protected DatabaseContext(JdoConf jdoConf, int index, org.exolab.castor.mapping.Mapping mapping, ConnectionFactory factory) {
        this._jdoConf = jdoConf;
        this._index = index;
        this._name = jdoConf.getDatabase(index).getName();
        this._mapping = mapping;
        this._txManager = null;
        this._factory = factory;
    }

    public void initialize() throws MappingException {
        if (!this._initialized) {
            this.initializeMapping();
            JDOConfAdapter adapt = new JDOConfAdapter(this._jdoConf);
            String name = adapt.getName();
            String txm = adapt.getTransactionManager();
            Properties prop = adapt.getTransactionManagerParameters();
            AbstractProperties properties = CPAProperties.getInstance();
            TransactionManagerRegistry txr = new TransactionManagerRegistry(properties);
            try {
                txr.registerTransactionManager(name, txm, prop);
                this._txManager = txr.getTransactionManager(name);
            }
            catch (TransactionManagerAcquireException ex) {
                throw new MappingException((Exception)ex);
            }
            this.initializeEngine(this._jdoConf.getDatabase(this._index).getEngine());
            this.initializeFactory();
            this._initialized = true;
        }
    }

    private void initializeMapping() throws MappingException {
        try {
            Enumeration<? extends Mapping> mappings = this._jdoConf.getDatabase(this._index).enumerateMapping();
            while (mappings.hasMoreElements()) {
                Mapping mapConf = mappings.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading the mapping descriptor: " + mapConf.getHref()));
                }
                if (mapConf.getHref() == null) continue;
                this._mapping.loadMapping(mapConf.getHref());
            }
        }
        catch (MappingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappingException(ex);
        }
    }

    private void initializeEngine(String engine) throws MappingException {
        PersistenceFactory factory = engine == null ? PersistenceFactoryRegistry.getPersistenceFactory(GENERIC_ENGINE) : PersistenceFactoryRegistry.getPersistenceFactory(engine);
        if (factory == null) {
            String msg = Messages.format((String)"jdo.noSuchEngine", (Object)engine);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
        MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(this._mapping, BindingType.JDO, (Object)factory);
        if (this._classDescriptorResolver == null) {
            this._classDescriptorResolver = new JDOClassDescriptorResolverImpl();
        }
        this._classDescriptorResolver.setMappingLoader(mappingLoader);
        this._engine = new PersistenceEngineFactory().createEngine(this, this._classDescriptorResolver, factory);
    }

    public void initializeFactory() throws MappingException {
        this._factory.initializeFactory();
    }

    public ConnectionFactory getConnectionFactory() {
        return this._factory;
    }

    public String getName() {
        return this._name;
    }

    public Database getDatabase() {
        return this._jdoConf.getDatabase(this._index);
    }

    public org.exolab.castor.mapping.Mapping getMapping() {
        return this._mapping;
    }

    public TransactionManager getTransactionManager() {
        return this._txManager;
    }

    public LockEngine getEngine() {
        return this._engine;
    }

    public void setClassDescriptorResolver(JDOClassDescriptorResolver classDescriptorResolver) {
        this._classDescriptorResolver = classDescriptorResolver;
    }
}

