/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.jpa.info;

import javax.persistence.FetchType;
import org.castor.core.nature.PropertyHolder;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.jdo.jpa.info.ClassInfo;
import org.castor.jdo.jpa.info.ClassInfoBuilder;
import org.castor.jdo.jpa.info.FieldInfo;
import org.castor.jdo.jpa.natures.JPAClassNature;
import org.castor.jdo.jpa.natures.JPAFieldNature;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.Sql;
import org.exolab.castor.mapping.xml.types.FieldMappingCollectionType;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ResolverException;

public final class InfoToDescriptorConverter {
    private InfoToDescriptorConverter() {
    }

    public static void convert(ClassInfo classInfo, ClassDescriptorResolver cdr, ClassDescriptorImpl descriptor) throws MappingException {
        if (classInfo == null) {
            throw new IllegalArgumentException("ClassInfo must not be null!");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("ClassDescriptor must not be null!");
        }
        if (!classInfo.hasNature(JPAClassNature.class.getName())) {
            throw new IllegalArgumentException("ClassInfo must have JPAClassNature on it!");
        }
        if (!Types.isConstructable(classInfo.getDescribedClass(), (boolean)true)) {
            throw new MappingException("mapping.classNotConstructable", (Object)classInfo.getDescribedClass().getName());
        }
        JPAClassNature nature = new JPAClassNature(classInfo);
        descriptor.addNature(ClassDescriptorJDONature.class.getName());
        ClassDescriptorJDONature jdoNature = new ClassDescriptorJDONature((PropertyHolder)descriptor);
        descriptor.setJavaClass(classInfo.getDescribedClass());
        descriptor.setExtends(null);
        Class<?> extendedClass = classInfo.getExtendedClass();
        if (extendedClass != null && extendedClass != Object.class) {
            ClassDescriptor extendedClassDescriptor = null;
            try {
                extendedClassDescriptor = cdr.resolve(extendedClass);
                if (extendedClassDescriptor == null) {
                    throw new MappingException("Unable to resolve extended class " + extendedClass.getName() + " in " + classInfo.getDescribedClass().getName());
                }
            }
            catch (ResolverException e) {
                throw new MappingException("Unable to resolve extended class " + extendedClass.getName() + " in " + classInfo.getDescribedClass().getName(), (Exception)((Object)e));
            }
            descriptor.setExtends(extendedClassDescriptor);
            if (extendedClassDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
                new ClassDescriptorJDONature((PropertyHolder)extendedClassDescriptor).addExtended((ClassDescriptor)descriptor);
            }
        }
        descriptor.setDepends(null);
        ClassMapping clsMapping = new ClassMapping();
        clsMapping.setExtends(null);
        clsMapping.setName(classInfo.getDescribedClass().getName());
        for (FieldInfo idInfo : classInfo.getKeyFieldInfos()) {
            clsMapping.addIdentity(idInfo.getFieldName());
        }
        clsMapping.setClassChoice(new ClassChoice());
        descriptor.setMapping(clsMapping);
        MapTo mapTo = new MapTo();
        clsMapping.setMapTo(mapTo);
        String tableName = nature.getTableName();
        if (tableName == null || tableName.trim().length() == 0) {
            tableName = nature.getEntityName();
        }
        jdoNature.setTableName(tableName);
        mapTo.setTable(tableName);
        jdoNature.addCacheParam("name", classInfo.getDescribedClass().getName());
        jdoNature.setAccessMode(null);
        jdoNature.setKeyGeneratorDescriptor(null);
        FieldDescriptor[] keys = new FieldDescriptor[classInfo.getKeyFieldCount()];
        int i = 0;
        for (FieldInfo fieldInfo : classInfo.getKeyFieldInfos()) {
            keys[i] = InfoToDescriptorConverter.convert(descriptor, fieldInfo, cdr);
            ++i;
        }
        descriptor.setIdentities(keys);
        FieldDescriptor[] fields = new FieldDescriptor[classInfo.getFieldCount()];
        i = 0;
        for (FieldInfo fieldInfo : classInfo.getFieldInfos()) {
            fields[i] = InfoToDescriptorConverter.convert(descriptor, fieldInfo, cdr);
            ++i;
        }
        descriptor.setFields(fields);
    }

    private static FieldDescriptorImpl convert(ClassDescriptorImpl parent, FieldInfo fieldInfo, ClassDescriptorResolver cdr) throws MappingException {
        if (!fieldInfo.hasNature(JPAFieldNature.class.getName())) {
            throw new IllegalArgumentException("FieldInfo must have JPAFieldNature on it!");
        }
        JPAFieldNature jpaNature = new JPAFieldNature(fieldInfo);
        String fieldName = fieldInfo.getFieldName();
        TypeInfo typeInfo = InfoToDescriptorConverter.createTypeInfo(fieldInfo, jpaNature);
        FieldHandler handler = InfoToDescriptorConverter.createFieldHandler(fieldInfo, typeInfo);
        boolean isTransient = jpaNature.isTransient();
        FieldDescriptorImpl fieldDescriptor = new FieldDescriptorImpl(fieldName, typeInfo, handler, isTransient);
        fieldDescriptor.addNature(FieldDescriptorJDONature.class.getName());
        FieldDescriptorJDONature jdoNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
        Class javaType = Types.typeFromPrimitive((Class)typeInfo.getFieldType());
        int sqlType = SQLTypeInfos.javaType2sqlTypeNum(javaType);
        if (jpaNature.isManyToManyInverseCopy()) {
            ClassInfo relatedClass = ClassInfoBuilder.buildClassInfo(jpaNature.getRelationTargetEntity());
            String relatedFieldName = jpaNature.getRelationMappedBy();
            FieldInfo relatedField = relatedClass.getFieldInfoByName(relatedFieldName);
            JPAFieldNature relatedFieldNature = new JPAFieldNature(relatedField);
            jpaNature.setJoinTableCatalog(relatedFieldNature.getJoinTableCatalog());
            jpaNature.setJoinTableName(relatedFieldNature.getJoinTableName());
            jpaNature.setJoinTableSchema(relatedFieldNature.getJoinTableSchema());
            jpaNature.setJoinTableInverseJoinColumns(relatedFieldNature.getJoinTableJoinColumns());
            jpaNature.setJoinTableJoinColumns(relatedFieldNature.getJoinTableInverseJoinColumns());
        }
        fieldDescriptor.setContainingClassDescriptor((ClassDescriptor)parent);
        fieldDescriptor.setFieldType(typeInfo.getFieldType());
        fieldDescriptor.setIdentity(jpaNature.isId());
        if (InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            try {
                fieldDescriptor.setClassDescriptor(cdr.resolve(jpaNature.getRelationTargetEntity()));
            }
            catch (ResolverException e) {
                throw new MappingException("Can not resolve ClassDescriptor for Class " + jpaNature.getRelationTargetEntity().getName() + " needed by " + fieldInfo.getDeclaringClassInfo().getDescribedClass().getName() + "#" + fieldName);
            }
        }
        fieldDescriptor.setRequired(InfoToDescriptorConverter.createRequired(jpaNature));
        fieldDescriptor.setMultivalued(false);
        if (jpaNature.isOneToMany() || jpaNature.isManyToMany()) {
            fieldDescriptor.setMultivalued(true);
        }
        fieldDescriptor.setImmutable(false);
        jdoNature.setSQLType(new int[]{sqlType});
        jdoNature.setSQLName(InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldDescriptor.getClassDescriptor()));
        jdoNature.setManyKey(InfoToDescriptorConverter.createManyKey(fieldName, jpaNature, fieldDescriptor.getClassDescriptor(), parent));
        if (jpaNature.isManyToMany()) {
            jdoNature.setManyTable(jpaNature.getJoinTableName());
        }
        jdoNature.setTypeConvertor(null);
        jdoNature.setReadOnly(false);
        jdoNature.setDirtyCheck(true);
        FieldMapping fieldMapping = new FieldMapping();
        parent.getMapping().getClassChoice().addFieldMapping(fieldMapping);
        fieldMapping.setName(fieldName);
        fieldMapping.setIdentity(fieldDescriptor.isIdentity());
        fieldMapping.setRequired(fieldDescriptor.isRequired());
        fieldMapping.setLazy(InfoToDescriptorConverter.createFMLazy(jpaNature));
        fieldMapping.setDirect(false);
        fieldMapping.setGetMethod(fieldInfo.getGetterMethod().getName());
        fieldMapping.setSetMethod(fieldInfo.getSetterMethod().getName());
        fieldMapping.setCollection(InfoToDescriptorConverter.createColletionType(jpaNature));
        fieldMapping.setSql(InfoToDescriptorConverter.createFMSQL(fieldName, jpaNature, fieldDescriptor.getClassDescriptor(), sqlType, parent));
        fieldMapping.setType(typeInfo.getFieldType().getName());
        return fieldDescriptor;
    }

    private static FieldHandler createFieldHandler(FieldInfo fieldInfo, TypeInfo typeInfo) throws MappingException {
        FieldHandlerImpl fieldHandler = null;
        fieldHandler = new FieldHandlerImpl(fieldInfo.getFieldName(), null, null, fieldInfo.getGetterMethod(), fieldInfo.getSetterMethod(), typeInfo);
        return fieldHandler;
    }

    private static TypeInfo createTypeInfo(FieldInfo fieldInfo, JPAFieldNature jpaNature) {
        if (InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            return new TypeInfo(jpaNature.getRelationTargetEntity());
        }
        return new TypeInfo(fieldInfo.getFieldType());
    }

    private static boolean createRequired(JPAFieldNature jpaNature) {
        if (jpaNature.getColumnNullable() != null) {
            return jpaNature.getColumnNullable() == false;
        }
        if (jpaNature.isId()) {
            return true;
        }
        if (jpaNature.isOneToMany()) {
            return true;
        }
        if (jpaNature.isManyToMany()) {
            return true;
        }
        if (!jpaNature.isRelationOptional()) {
            return true;
        }
        return !jpaNature.isBasicOptional();
    }

    private static FieldMappingCollectionType createColletionType(JPAFieldNature jpaNature) {
        if (jpaNature.getRelationCollectionType() != null) {
            String collectionTypeName = jpaNature.getRelationCollectionType().getSimpleName().toLowerCase();
            return FieldMappingCollectionType.valueOf((String)collectionTypeName);
        }
        return null;
    }

    private static Sql createFMSQL(String fieldName, JPAFieldNature jpaNature, ClassDescriptor fieldClassDescriptor, int sqlType, ClassDescriptorImpl parentClassDescriptor) throws MappingException {
        Sql fieldSql = new Sql();
        if (!InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            for (String sqlName : InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldClassDescriptor)) {
                fieldSql.addName(sqlName);
            }
            fieldSql.setType(SQLTypeInfos.sqlTypeNum2sqlTypeName(sqlType));
        } else if (InfoToDescriptorConverter.isXToOne(jpaNature)) {
            for (String sqlName : InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldClassDescriptor)) {
                fieldSql.addName(sqlName);
                fieldSql.addManyKey(sqlName);
            }
        } else {
            String[] manyKeys;
            for (String sqlName : manyKeys = InfoToDescriptorConverter.createManyKey(fieldName, jpaNature, fieldClassDescriptor, parentClassDescriptor)) {
                fieldSql.addName(sqlName);
                fieldSql.addManyKey(sqlName);
            }
        }
        return fieldSql;
    }

    private static boolean createFMLazy(JPAFieldNature jpaNature) {
        if (jpaNature.isRelationLazyFetch()) {
            return true;
        }
        return FetchType.LAZY.equals((Object)jpaNature.getBasicFetch());
    }

    private static String[] createManyKey(String fieldName, JPAFieldNature jpaNature, ClassDescriptor fieldClassDescriptor, ClassDescriptorImpl parentClassDescriptor) {
        if (InfoToDescriptorConverter.isXToOne(jpaNature)) {
            return InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldClassDescriptor);
        }
        if (jpaNature.isOneToMany()) {
            String[] sqlManyKey = new String[]{jpaNature.getJoinColumnName()};
            if ((sqlManyKey[0] == null || sqlManyKey[0].trim().length() == 0) && jpaNature.getRelationMappedBy() != null) {
                sqlManyKey[0] = jpaNature.getRelationMappedBy() + "_" + parentClassDescriptor.getIdentity().getFieldName();
            }
            return sqlManyKey;
        }
        if (jpaNature.isManyToMany()) {
            String[] sqlManyKey = new String[]{jpaNature.getJoinTableJoinColumns()[0].name()};
            if (sqlManyKey[0] == null || sqlManyKey[0].trim().length() == 0) {
                throw new IllegalStateException("Could not find JoinColumn definition on M:N relation! This must be defined on either sides of the relation!");
            }
            return sqlManyKey;
        }
        return null;
    }

    private static String[] createSQLName(String fieldName, JPAFieldNature jpaNature, ClassDescriptor fieldClassDescriptor) {
        String[] sqlName = new String[1];
        if (!InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            sqlName[0] = jpaNature.getColumnName();
            if (sqlName[0] == null || sqlName[0].trim().length() == 0) {
                sqlName[0] = fieldName;
            }
        } else if (InfoToDescriptorConverter.isXToOne(jpaNature)) {
            sqlName[0] = jpaNature.getJoinColumnName();
            if (sqlName[0] == null || sqlName[0].trim().length() == 0) {
                sqlName[0] = fieldName + "_" + fieldClassDescriptor.getIdentity().getFieldName();
            }
        } else {
            sqlName = null;
        }
        return sqlName;
    }

    private static boolean isXToOne(JPAFieldNature jpaNature) {
        return jpaNature.isOneToOne() || jpaNature.isManyToOne();
    }

    private static boolean hasFieldRelation(JPAFieldNature jpaNature) {
        return jpaNature.isOneToOne() || jpaNature.isManyToOne() || jpaNature.isOneToMany() || jpaNature.isManyToMany();
    }
}

