/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.BaseNature;
import org.castor.jdo.jpa.natures.JPAFieldNature;
import org.castor.jdo.jpa.processors.BaseJPAAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAJoinColumnProcessor
extends BaseJPAAnnotationProcessor {
    private static Log _log = LogFactory.getFactory().getInstance(JPAJoinColumnProcessor.class);

    public Class<? extends Annotation> forAnnotationClass() {
        return JoinColumn.class;
    }

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) {
        if (info instanceof JPAFieldNature && annotation instanceof JoinColumn && (target instanceof Field || target instanceof Method)) {
            _log.debug((Object)("processing field annotation " + ((Object)annotation).toString()));
            boolean targetValid = false;
            if (target.getAnnotation(OneToOne.class) != null) {
                targetValid = true;
            }
            if (target.getAnnotation(ManyToOne.class) != null) {
                targetValid = true;
            }
            if (target.getAnnotation(OneToMany.class) != null) {
                targetValid = true;
            }
            if (!targetValid) {
                _log.error((Object)("JoinTable annotation on " + ((Member)((Object)target)).getName() + " is not valid! Needs a relationship annotation! Ignoring @JoinTable!"));
                return false;
            }
            JPAFieldNature jpaFieldNature = (JPAFieldNature)info;
            JoinColumn joinColumn = (JoinColumn)annotation;
            jpaFieldNature.setJoinColumnName(joinColumn.name());
            jpaFieldNature.setJoinColumnReferencedColumnName(joinColumn.referencedColumnName());
            jpaFieldNature.setJoinColumnUnique(joinColumn.unique());
            jpaFieldNature.setJoinColumnNullable(joinColumn.nullable());
            jpaFieldNature.setJoinColumnInsertable(joinColumn.insertable());
            jpaFieldNature.setJoinColumnUpdatable(joinColumn.updatable());
            jpaFieldNature.setJoinColumnColumnDefinition(joinColumn.columnDefinition());
            jpaFieldNature.setJoinColumnTable(joinColumn.table());
            return true;
        }
        return false;
    }
}

