/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.nature.BaseNature;
import org.castor.jdo.jpa.info.FieldInfo;
import org.castor.jdo.jpa.natures.JPAFieldNature;
import org.castor.jdo.jpa.processors.BaseJPAAnnotationProcessor;
import org.castor.jdo.jpa.processors.ReflectionsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAManyToManyProcessor
extends BaseJPAAnnotationProcessor {
    private static Log _log = LogFactory.getFactory().getInstance(JPAManyToManyProcessor.class);
    private String _mappedBy;
    private FieldInfo _fieldInfo;
    private AnnotatedElement _target;

    public Class<? extends Annotation> forAnnotationClass() {
        return ManyToMany.class;
    }

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) throws AnnotationTargetException {
        if (info instanceof JPAFieldNature && annotation instanceof ManyToMany && (target instanceof Method || target instanceof Field)) {
            Method otherPropertiesGetter;
            Class<?> collectionType;
            _log.debug((Object)("processing field annotation " + ((Object)annotation).toString()));
            JPAFieldNature jpaFieldNature = (JPAFieldNature)info;
            ManyToMany manyToMany = (ManyToMany)annotation;
            this._mappedBy = manyToMany.mappedBy();
            this._fieldInfo = jpaFieldNature.getFieldInfo();
            this._target = target;
            try {
                collectionType = ReflectionsHelper.getCollectionType(this._target, true);
            }
            catch (AnnotationTargetException e) {
                _log.error((Object)e.getMessage());
                throw e;
            }
            Class<?> targetEntity = manyToMany.targetEntity();
            if (Void.TYPE.equals(targetEntity)) {
                try {
                    targetEntity = ReflectionsHelper.getTargetEntityFromGenerics(this._target);
                    if (targetEntity == null) {
                        String className = ((Member)((Object)this._target)).getDeclaringClass().getName();
                        String targetName = ((Member)((Object)this._target)).getName();
                        String message = "Target entity for ManyToMany relation on " + className + "#" + targetName + " not specified - use generics or specify targetEntity!";
                        throw new AnnotationTargetException(message);
                    }
                }
                catch (AnnotationTargetException e) {
                    _log.error((Object)e.getMessage());
                    throw e;
                }
            }
            try {
                otherPropertiesGetter = this.getRelationOtherGetMethod(targetEntity);
            }
            catch (AnnotationTargetException e) {
                _log.error((Object)e.getMessage());
                throw e;
            }
            JoinTableStrategy joinTableStrategy = this.getJoinTableStrategy(otherPropertiesGetter);
            switch (joinTableStrategy) {
                case defaultHeOwns: 
                case defaultWeOwn: {
                    AnnotationTargetException e = new AnnotationTargetException("Default values for ManyToMany relations are not supported by Castor!");
                    _log.error((Object)e.getMessage());
                    throw e;
                }
                case inverseCopy: {
                    jpaFieldNature.setManyToManyInverseCopy(true);
                    break;
                }
            }
            jpaFieldNature.setRelationTargetEntity(targetEntity);
            jpaFieldNature.setRelationCollectionType(collectionType);
            if (manyToMany.cascade().length > 0) {
                _log.warn((Object)"Cascading of relations is not supported by Castor!");
            }
            jpaFieldNature.setRelationLazyFetch(false);
            if (manyToMany.fetch() == FetchType.LAZY) {
                jpaFieldNature.setRelationLazyFetch(true);
            }
            if (this._mappedBy.length() != 0) {
                jpaFieldNature.setRelationMappedBy(this._mappedBy);
            }
            jpaFieldNature.setManyToMany(true);
            return true;
        }
        return false;
    }

    private Method getRelationOtherGetMethod(Class<?> otherClass) throws AnnotationTargetException {
        Class<?> describedClass = this._fieldInfo.getDeclaringClassInfo().getDescribedClass();
        String fieldName = this._fieldInfo.getFieldName();
        if (this._mappedBy != null && this._mappedBy.length() != 0) {
            String propertyName = this._mappedBy.substring(0, 1).toUpperCase() + this._mappedBy.substring(1);
            String methodName = "get" + propertyName;
            try {
                Method otherMethod = otherClass.getMethod(methodName, new Class[0]);
                Class<?> targetEntityFromGenerics = ReflectionsHelper.getTargetEntityFromGenerics(otherMethod);
                if (describedClass.equals(targetEntityFromGenerics)) {
                    return otherMethod;
                }
                throw new AnnotationTargetException("MappedBy '" + this._mappedBy + "' in Class " + otherClass.getName() + " is not ManyToMany related with '" + describedClass.getName() + "' property '" + fieldName + "'!");
            }
            catch (AnnotationTargetException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AnnotationTargetException("MappedBy '" + this._mappedBy + "' does not exist in Class " + otherClass.getName() + " (could not find method '" + methodName + "')!");
            }
        }
        for (Method otherMethod : otherClass.getMethods()) {
            if (!otherMethod.getName().startsWith("get") || !this.checkMappedByToTarget(otherMethod, describedClass, fieldName)) continue;
            return otherMethod;
        }
        return null;
    }

    private boolean checkMappedByToTarget(AnnotatedElement property, Class<?> targetClass, String targetProperty) throws AnnotationTargetException {
        ManyToMany otherManyToMany = property.getAnnotation(ManyToMany.class);
        if (otherManyToMany != null) {
            Class<?> otherTargetEntity = otherManyToMany.targetEntity();
            if (Void.TYPE.equals(otherTargetEntity) && (otherTargetEntity = ReflectionsHelper.getTargetEntityFromGenerics(property)) == null) {
                String className = ((Member)((Object)property)).getDeclaringClass().getName();
                String targetName = ((Member)((Object)property)).getName();
                String message = "Target entity for ManyToMany relation on " + className + "#" + targetName + " not specified - use generics or specify targetEntity!";
                throw new AnnotationTargetException(message);
            }
            if (otherTargetEntity.equals(targetClass) && targetProperty.equals(otherManyToMany.mappedBy())) {
                return true;
            }
        }
        return false;
    }

    private JoinTableStrategy getJoinTableStrategy(Method otherPropertiesGetter) throws AnnotationTargetException {
        if (otherPropertiesGetter != null) {
            String otherFieldName = ReflectionsHelper.getFieldnameFromGetter(otherPropertiesGetter);
            String otherMappedBy = otherPropertiesGetter.getAnnotation(ManyToMany.class).mappedBy();
            boolean weOwn = this._fieldInfo.getFieldName().equals(otherMappedBy);
            boolean heOwns = otherFieldName.equals(this._mappedBy);
            if (this._target.getAnnotation(JoinTable.class) != null) {
                if (weOwn) {
                    return JoinTableStrategy.nothing;
                }
                String message = "JoinTable definition on a non-owning side (" + this._fieldInfo.getFieldName() + ") is not valid!";
                _log.error((Object)message);
                throw new AnnotationTargetException(message);
            }
            if (otherPropertiesGetter.getAnnotation(JoinTable.class) != null) {
                if (heOwns) {
                    return JoinTableStrategy.inverseCopy;
                }
                String message = "JoinTable definition on a non-owning side (" + this._mappedBy + ") is not valid!";
                _log.error((Object)message);
                throw new AnnotationTargetException(message);
            }
            if (heOwns && !weOwn) {
                return JoinTableStrategy.defaultHeOwns;
            }
            if (!heOwns && weOwn) {
                return JoinTableStrategy.defaultWeOwn;
            }
            String message = "Can not create default mapping if both entities ('" + this._fieldInfo.getDeclaringClassInfo().getDescribedClass().getName() + "' and '" + otherPropertiesGetter.getDeclaringClass().getName() + "')are owner!";
            _log.error((Object)message);
            throw new AnnotationTargetException(message);
        }
        if (this._target.getAnnotation(JoinTable.class) == null) {
            return JoinTableStrategy.defaultWeOwn;
        }
        return JoinTableStrategy.nothing;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JoinTableStrategy {
        inverseCopy,
        defaultWeOwn,
        defaultHeOwns,
        nothing;

    }
}

