/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.persist.ObjectTracker;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.ConnectionFailedException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DbMetaInfo;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.xml.NamedNativeQuery;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionContext
implements TransactionContext {
    private static final Log LOG = LogFactory.getLog(AbstractTransactionContext.class);
    private static final int DEFAULT_TIMEOUT = 30;
    private final ObjectTracker _tracker = new ObjectTracker();
    private ObjectLock _waitOnLock;
    private int _status = -1;
    private int _lockTimeout = 30;
    private int _txTimeout = 30;
    private Database _db;
    private boolean _autoStore;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private ArrayList<TxSynchronizable> _synchronizeList = new ArrayList();
    private Hashtable<LockEngine, Connection> _conns = new Hashtable();
    private DbMetaInfo _dbInfo;

    public AbstractTransactionContext(Database db) {
        this._db = db;
    }

    @Override
    public final void addTxSynchronizable(TxSynchronizable synchronizable) {
        this._synchronizeList.add(synchronizable);
    }

    @Override
    public final void removeTxSynchronizable(TxSynchronizable synchronizable) {
        this._synchronizeList.remove(synchronizable);
    }

    private void txcommitted() {
        for (int i = 0; i < this._synchronizeList.size(); ++i) {
            TxSynchronizable sync = this._synchronizeList.get(i);
            try {
                sync.committed(this);
                continue;
            }
            catch (Exception ex) {
                String cls = sync.getClass().getName();
                LOG.warn((Object)("Exception at " + cls + ".committed()"), (Throwable)ex);
            }
        }
    }

    private void txrolledback() {
        for (int i = 0; i < this._synchronizeList.size(); ++i) {
            TxSynchronizable sync = this._synchronizeList.get(i);
            try {
                sync.rolledback(this);
                continue;
            }
            catch (Exception ex) {
                String cls = sync.getClass().getName();
                LOG.warn((Object)("Exception at " + cls + ".rolledback()"), (Throwable)ex);
            }
        }
    }

    @Override
    public final void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    @Override
    public final boolean isAutoStore() {
        return this._autoStore;
    }

    @Override
    public final void setCallback(CallbackInterceptor callback) {
        this._callback = callback;
    }

    @Override
    public final void setInstanceFactory(InstanceFactory factory) {
        this._instanceFactory = factory;
    }

    @Override
    public final void setTransactionTimeout(int timeout) {
        this._txTimeout = timeout;
    }

    @Override
    public final int getTransactionTimeout() {
        return this._txTimeout;
    }

    @Override
    public final int getLockTimeout() {
        return this._lockTimeout;
    }

    @Override
    public final void setLockTimeout(int timeout) {
        this._lockTimeout = timeout >= 0 ? timeout : 0;
    }

    @Override
    public final void setStatus(int status) {
        this._status = status;
    }

    @Override
    public final Connection getConnection(LockEngine engine) throws ConnectionFailedException {
        Connection conn = this._conns.get(engine);
        if (conn == null) {
            conn = this.createConnection(engine);
            this._conns.put(engine, conn);
        }
        return conn;
    }

    protected abstract Connection createConnection(LockEngine var1) throws ConnectionFailedException;

    protected final Iterator<Connection> connectionsIterator() {
        return this._conns.values().iterator();
    }

    protected final void clearConnections() {
        this._conns.clear();
    }

    protected abstract void commitConnections() throws TransactionAbortedException;

    protected abstract void closeConnections() throws TransactionAbortedException;

    protected abstract void rollbackConnections();

    @Override
    public final DbMetaInfo getConnectionInfo(LockEngine engine) throws PersistenceException {
        Connection conn = this.getConnection(engine);
        if (this._dbInfo == null) {
            this._dbInfo = new DbMetaInfo(conn);
        }
        return this._dbInfo;
    }

    @Override
    public final synchronized Object fetch(ClassMolder molder, Identity identity, AccessMode suggestedAccessMode) throws PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        LockEngine engine = molder.getLockEngine();
        OID oid = new OID(molder, identity);
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        Object objectInTx = accessMode == AccessMode.ReadOnly ? this._tracker.getObjectForOID(engine, oid, true) : this._tracker.getObjectForOID(engine, oid, false);
        if (objectInTx != null) {
            if (engine != this._tracker.getMolderForObject(objectInTx).getLockEngine()) {
                throw new PersistenceException(Messages.format((String)"persist.multipleLoad", (Object)molder.getName(), (Object)identity));
            }
            if (this._tracker.isDeleted(objectInTx)) {
                return null;
            }
            if (!molder.isAssignableFrom(objectInTx.getClass())) {
                throw new PersistenceException(Messages.format((String)"persist.typeMismatch", (Object)molder.getName(), (Object)identity));
            }
            if (this._tracker.isCreated(objectInTx)) {
                return objectInTx;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || this._tracker.getOIDForObject(objectInTx).isDbLock())) {
                throw new PersistenceException(Messages.format((String)"persist.lockConflict", (Object)molder.getName(), (Object)identity));
            }
            return objectInTx;
        }
        return null;
    }

    @Override
    public final synchronized Object load(Identity identity, ProposedEntity proposedObject, AccessMode suggestedAccessMode) throws PersistenceException {
        return this.load(identity, proposedObject, suggestedAccessMode, null);
    }

    @Override
    public final synchronized Object load(Identity identity, ProposedEntity proposedObject, AccessMode suggestedAccessMode, QueryResults results) throws PersistenceException {
        ClassMolder molder = proposedObject.getActualClassMolder();
        LockEngine engine = molder.getLockEngine();
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        if (proposedObject.getEntity() != null && !molder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(proposedObject.getProposedEntityClass())) {
            throw new PersistenceException(Messages.format((String)"persist.typeMismatch", (Object)molder.getName(), (Object)proposedObject.getProposedEntityClass()));
        }
        OID oid = new OID(molder, identity);
        AccessMode accessMode = molder.getAccessMode(suggestedAccessMode);
        Object objectInTx = accessMode == AccessMode.ReadOnly ? this._tracker.getObjectForOID(engine, oid, true) : this._tracker.getObjectForOID(engine, oid, false);
        if (objectInTx != null) {
            if (proposedObject.getEntity() != null && proposedObject.getEntity() != objectInTx) {
                throw new PersistenceException(Messages.format((String)"persist.multipleLoad", (Object)molder.getName(), (Object)identity));
            }
            if (engine != this._tracker.getMolderForObject(objectInTx).getLockEngine()) {
                throw new PersistenceException(Messages.format((String)"persist.multipleLoad", (Object)molder.getName(), (Object)identity));
            }
            if (this._tracker.isDeleted(objectInTx)) {
                throw new ObjectNotFoundException(Messages.format((String)"persist.objectNotFound", (Object)molder.getName(), (Object)identity));
            }
            if (!molder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(objectInTx.getClass())) {
                throw new PersistenceException(Messages.format((String)"persist.typeMismatch", (Object)molder.getName(), objectInTx.getClass()));
            }
            if (this._tracker.isCreated(objectInTx)) {
                return objectInTx;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || this._tracker.getOIDForObject(objectInTx).isDbLock())) {
                throw new PersistenceException(Messages.format((String)"persist.lockConflict", (Object)molder.getName(), (Object)identity));
            }
            proposedObject.setProposedEntityClass(objectInTx.getClass());
            proposedObject.setActualEntityClass(objectInTx.getClass());
            proposedObject.setEntity(objectInTx);
            return objectInTx;
        }
        try {
            objectInTx = proposedObject.getEntity() != null ? proposedObject.getEntity() : (this._instanceFactory != null ? this._instanceFactory.newInstance(molder.getName(), this._db.getClassLoader()) : molder.newInstance(this._db.getClassLoader()));
            molder.setIdentity(this, objectInTx, identity);
            proposedObject.setProposedEntityClass(objectInTx.getClass());
            proposedObject.setActualEntityClass(objectInTx.getClass());
            proposedObject.setEntity(objectInTx);
            this.trackObject(molder, oid, proposedObject.getEntity());
            engine.load(this, oid, proposedObject, suggestedAccessMode, this._lockTimeout, results, molder);
        }
        catch (ClassCastException except) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw except;
        }
        catch (ObjectNotFoundException except) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw except;
        }
        catch (ConnectionFailedException except) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw except;
        }
        catch (LockNotGrantedException except) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw except;
        }
        catch (ClassNotPersistenceCapableException except) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)((Object)except)));
        }
        catch (InstantiationException e) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw new PersistenceException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw new PersistenceException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            this._tracker.untrackObject(proposedObject.getEntity());
            throw new PersistenceException(e.getMessage(), e);
        }
        objectInTx = proposedObject.getEntity();
        try {
            if (this._callback != null) {
                this._callback.using(objectInTx, this._db);
                this._callback.loaded(objectInTx, accessMode);
            } else if (molder.getCallback() != null) {
                molder.getCallback().using(objectInTx, this._db);
                molder.getCallback().loaded(objectInTx, accessMode);
            }
        }
        catch (Exception except) {
            this.release(objectInTx);
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
        if (accessMode == AccessMode.ReadOnly) {
            this._tracker.markReadOnly(objectInTx);
            engine.releaseLock(this, oid);
        }
        return objectInTx;
    }

    public void untrackObject(Object object) {
        this._tracker.untrackObject(object);
    }

    public void trackObject(ClassMolder molder, OID oid, Object object) {
        this._tracker.trackObject(molder, oid, object);
    }

    @Override
    public final synchronized QueryResults query(LockEngine engine, PersistenceQuery query, AccessMode accessMode, boolean scrollable) throws PersistenceException {
        query.execute(this.getConnection(engine), accessMode, scrollable);
        return new QueryResults(this, engine, query, accessMode, this._db);
    }

    @Override
    public final synchronized void markCreate(ClassMolder molder, Object object, OID rootObjectOID) throws PersistenceException {
        if (object == null) {
            throw new PersistenceException("Attempted to mark a null object as created.");
        }
        LockEngine engine = molder.getLockEngine();
        Identity identity = molder.getIdentity(this, object);
        if (this._autoStore && this._tracker.isTracking(object)) {
            return;
        }
        if (this._tracker.isDeleted(object)) {
            OID deletedoid = this._tracker.getOIDForObject(object);
            throw new PersistenceException(Messages.format((String)"persist.objectAlreadyPersistent", (Object)object.getClass().getName(), (Object)(deletedoid != null ? deletedoid.getIdentity() : null)));
        }
        OID oid = new OID(molder, rootObjectOID, identity);
        Object trackedObject = this._tracker.getObjectForOID(engine, oid, false);
        if (identity != null && trackedObject != null) {
            if (trackedObject != object) {
                throw new DuplicateIdentityException("Object being tracked with the OID created for a dependent object does not match the object to be marked for creation. Fundamental Tracking Error.");
            }
            if (this._tracker.isDeleted(object)) {
                this._tracker.unmarkDeleted(object);
            }
        }
        try {
            this._tracker.trackObject(molder, oid, object);
            this._tracker.markCreating(object);
            if (this._callback != null) {
                this._callback.creating(object, this._db);
            } else if (molder.getCallback() != null) {
                molder.getCallback().creating(object, this._db);
            }
            engine.markCreate(this, oid, object);
        }
        catch (LockNotGrantedException lneg) {
            this._tracker.untrackObject(object);
            throw lneg;
        }
        catch (PersistenceException pe) {
            this._tracker.untrackObject(object);
            throw pe;
        }
        catch (Exception e) {
            this._tracker.untrackObject(object);
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)e), e);
        }
    }

    @Override
    public final synchronized void create(ClassMolder molder, Object object, OID depended) throws PersistenceException {
        this.markCreate(molder, object, depended);
        this.walkObjectsToBeCreated();
        this.walkObjectsWhichNeedCacheUpdate();
    }

    private synchronized void walkObjectsToBeCreated() throws PersistenceException {
        Collection createableObjects = this._tracker.getObjectsWithCreatingStateSortedByLowestMolderPriority();
        for (Object toBeCreated : createableObjects) {
            OID toBeCreatedOID = this._tracker.getOIDForObject(toBeCreated);
            ClassMolder toBeCreatedMolder = this._tracker.getMolderForObject(toBeCreated);
            LockEngine toBeCreatedLockEngine = toBeCreatedMolder.getLockEngine();
            try {
                if (!this._tracker.isCreating(toBeCreated)) continue;
                if (this._callback != null) {
                    this._callback.creating(toBeCreated, this._db);
                } else if (toBeCreatedMolder.getCallback() != null) {
                    toBeCreatedMolder.getCallback().creating(toBeCreated, this._db);
                }
                OID oid = toBeCreatedLockEngine.create(this, toBeCreatedOID, toBeCreated);
                if (oid.getIdentity() == null) {
                    throw new IllegalStateException("oid.getIdentity() is null after create!");
                }
                this._tracker.trackOIDChange(toBeCreated, toBeCreatedLockEngine, toBeCreatedOID, oid);
                this._tracker.markCreated(toBeCreated);
                if (this._callback != null) {
                    this._callback.using(toBeCreated, this._db);
                    this._callback.created(toBeCreated);
                    continue;
                }
                if (toBeCreatedMolder.getCallback() == null) continue;
                toBeCreatedMolder.getCallback().using(toBeCreated, this._db);
                toBeCreatedMolder.getCallback().created(toBeCreated);
            }
            catch (Exception except) {
                if (this._callback != null) {
                    this._callback.releasing(toBeCreated, false);
                } else if (toBeCreatedMolder.getCallback() != null) {
                    toBeCreatedMolder.getCallback().releasing(toBeCreated, false);
                }
                this._tracker.untrackObject(toBeCreated);
                if (except instanceof DuplicateIdentityException) {
                    throw (DuplicateIdentityException)((Object)except);
                }
                if (except instanceof PersistenceException) {
                    throw (PersistenceException)((Object)except);
                }
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
    }

    private void walkObjectsWhichNeedCacheUpdate() {
        Collection objectsMarkedForUpdate = this._tracker.getObjectsWithUpdateCacheNeededState();
        for (Object toCacheUpdate : objectsMarkedForUpdate) {
            if (!this._tracker.isCreated(toCacheUpdate)) continue;
            OID toCacheUpdateOID = this._tracker.getOIDForObject(toCacheUpdate);
            LockEngine toCacheUpdateLocker = this._tracker.getMolderForObject(toCacheUpdate).getLockEngine();
            toCacheUpdateLocker.updateCache(this, toCacheUpdateOID, toCacheUpdate);
            this._tracker.unmarkUpdateCacheNeeded(toCacheUpdate);
        }
    }

    @Override
    public final boolean markUpdate(ClassMolder molder, Object object, OID depended) throws PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        LockEngine engine = molder.getLockEngine();
        Identity identity = molder.getActualIdentity(this, object);
        if (molder.isDefaultIdentity(identity)) {
            identity = null;
        }
        OID oid = new OID(molder, depended, identity);
        Object foundInTransaction = this._tracker.getObjectForOID(engine, oid, false);
        if (this._autoStore && foundInTransaction != null && foundInTransaction == object) {
            return false;
        }
        if (foundInTransaction != null) {
            if (this._tracker.isDeleted(foundInTransaction)) {
                throw new ObjectDeletedException(Messages.format((String)"persist.objectDeleted", object.getClass(), (Object)identity));
            }
            throw new DuplicateIdentityException("update object which is already in the transaction");
        }
        try {
            this._tracker.trackObject(molder, oid, object);
            if (engine.update(this, oid, object, null, 0)) {
                this._tracker.markCreating(object);
            }
        }
        catch (DuplicateIdentityException lneg) {
            this._tracker.untrackObject(object);
            throw lneg;
        }
        catch (PersistenceException pe) {
            this._tracker.untrackObject(object);
            throw pe;
        }
        catch (Exception e) {
            this._tracker.untrackObject(object);
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)e), e);
        }
        if (!this._tracker.isCreating(object)) {
            try {
                if (this._callback != null) {
                    this._callback.using(object, this._db);
                    this._callback.updated(object);
                } else if (molder.getCallback() != null) {
                    molder.getCallback().using(object, this._db);
                    molder.getCallback().updated(object);
                }
            }
            catch (Exception except) {
                this.release(object);
                if (except instanceof PersistenceException) {
                    throw (PersistenceException)((Object)except);
                }
                throw new PersistenceException(except.getMessage(), except);
            }
            return false;
        }
        return true;
    }

    @Override
    public final synchronized void update(ClassMolder molder, Object object, OID depended) throws PersistenceException {
        this.markUpdate(molder, object, depended);
        this.walkObjectsToBeCreated();
        this.walkObjectsWhichNeedCacheUpdate();
    }

    @Override
    public final synchronized void delete(Object object) throws PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to be deleted is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format((String)"persist.objectNotPersistent", (Object)object.getClass().getName()));
        }
        ClassMolder molder = this._tracker.getMolderForObject(object);
        LockEngine engine = molder.getLockEngine();
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format((String)"persist.objectDeleted", (Object)object.getClass().getName(), (Object)oid.getIdentity()));
        }
        try {
            if (this._callback != null) {
                this._callback.removing(object);
            } else if (molder.getCallback() != null) {
                molder.getCallback().removing(object);
            }
        }
        catch (Exception except) {
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
        try {
            this._tracker.markDeleted(object);
            engine.softLock(this, oid, this._lockTimeout);
            engine.markDelete(this, oid, object, this._lockTimeout);
            try {
                if (this._callback != null) {
                    this._callback.removed(object);
                } else if (molder.getCallback() != null) {
                    molder.getCallback().removed(object);
                }
            }
            catch (Exception except) {
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
            }
        }
        catch (ObjectDeletedException except) {
            this._tracker.untrackObject(object);
        }
    }

    @Override
    public final synchronized void writeLock(Object object, int timeout) throws PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to acquire lock is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format((String)"persist.objectNotPersistent", (Object)object.getClass().getName()));
        }
        LockEngine engine = this._tracker.getMolderForObject(object).getLockEngine();
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format((String)"persist.objectDeleted", object.getClass(), (Object)oid.getIdentity()));
        }
        try {
            engine.writeLock(this, oid, timeout);
        }
        catch (ObjectDeletedException except) {
            this._tracker.untrackObject(object);
            throw new ObjectNotPersistentException(Messages.format((String)"persist.objectNotPersistent", (Object)object.getClass().getName()));
        }
        catch (LockNotGrantedException except) {
            throw except;
        }
    }

    @Override
    public final synchronized void markModified(Object object, boolean updatePersist, boolean updateCache) {
        if (updatePersist) {
            this._tracker.markUpdatePersistNeeded(object);
        }
        if (updateCache) {
            this._tracker.markUpdateCacheNeeded(object);
        }
    }

    private synchronized void release(Object object) throws PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to release lock is null!");
        }
        if (!this._tracker.isTracking(object)) {
            throw new ObjectNotPersistentException(Messages.format((String)"persist.objectNotPersistent", object.getClass().getName().getClass()));
        }
        ClassMolder molder = this._tracker.getMolderForObject(object);
        LockEngine engine = molder.getLockEngine();
        OID oid = this._tracker.getOIDForObject(object);
        if (this._tracker.isDeleted(object)) {
            throw new ObjectDeletedException(Messages.format((String)"persist.objectDeleted", (Object)object.getClass().getName(), (Object)oid.getIdentity()));
        }
        engine.releaseLock(this, oid);
        this._tracker.untrackObject(object);
        if (this._callback != null) {
            this._callback.releasing(object, false);
        } else if (molder != null && molder.getCallback() != null) {
            molder.getCallback().releasing(object, false);
        }
        if (engine == null) {
            throw new PersistenceException("Release: Missing engine during release call; fundamental tracking error.");
        }
        if (molder == null) {
            throw new PersistenceException("Release: Missing molder during release call; fundamental tracking error.");
        }
        if (oid == null) {
            throw new PersistenceException("Release: Missing OID during release call; fundamental tracking error.");
        }
    }

    @Override
    public final synchronized boolean prepare() throws TransactionAbortedException {
        ArrayList todo = new ArrayList();
        ArrayList done = new ArrayList();
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 0) {
            throw new IllegalStateException(Messages.message((String)"persist.noTransaction"));
        }
        try {
            if (this._tracker.readWriteSize() == 0) {
                this._status = 2;
                return false;
            }
            Collection readWriteObjects = this._tracker.getReadWriteObjects();
            while (readWriteObjects.size() != done.size()) {
                todo.clear();
                for (Object object : readWriteObjects) {
                    if (done.contains(object)) continue;
                    todo.add(object);
                }
                for (Object object : todo) {
                    OID oid;
                    LockEngine engine;
                    OID newoid;
                    if (!this._tracker.isDeleted(object) && !this._tracker.isCreating(object) && (newoid = (engine = this._tracker.getMolderForObject(object).getLockEngine()).preStore(this, oid = this._tracker.getOIDForObject(object), object, this._lockTimeout)) != null) {
                        this._tracker.trackOIDChange(object, engine, oid, newoid);
                        this._tracker.markUpdateCacheNeeded(object);
                    }
                    done.add(object);
                }
            }
            this.walkObjectsToBeCreated();
            this.prepareForCreate();
            this._status = 7;
            this.prepareForDelete();
            this._status = 2;
            return true;
        }
        catch (Exception except) {
            this._status = 1;
            if (except instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)((Object)except);
            }
            throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)except), except);
        }
    }

    private void prepareForCreate() throws PersistenceException {
        Collection allObjects = this._tracker.getReadWriteObjects();
        for (Object toPrepare : allObjects) {
            boolean isCreating = this._tracker.isCreating(toPrepare);
            boolean isDeleted = this._tracker.isDeleted(toPrepare);
            boolean needsPersist = this._tracker.isUpdatePersistNeeded(toPrepare);
            boolean needsCache = this._tracker.isUpdateCacheNeeded(toPrepare);
            ClassMolder molder = this._tracker.getMolderForObject(toPrepare);
            LockEngine engine = molder.getLockEngine();
            OID oid = this._tracker.getOIDForObject(toPrepare);
            if (!isDeleted && !isCreating) {
                if (needsPersist) {
                    engine.store(this, oid, toPrepare);
                }
                if (needsCache) {
                    engine.softLock(this, oid, this._lockTimeout);
                }
            }
            if (!isDeleted && this._callback != null) {
                try {
                    this._callback.storing(toPrepare, needsCache);
                    continue;
                }
                catch (Exception except) {
                    throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)except), except);
                }
            }
            if (isDeleted || molder.getCallback() == null) continue;
            try {
                molder.getCallback().storing(toPrepare, needsCache);
            }
            catch (Exception except) {
                throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
    }

    private void prepareForDelete() throws PersistenceException {
        Collection objectsToDelete = this._tracker.getObjectsWithDeletedStateSortedByHighestMolderPriority();
        for (Object object : objectsToDelete) {
            LockEngine engine = this._tracker.getMolderForObject(object).getLockEngine();
            OID oid = this._tracker.getOIDForObject(object);
            engine.delete(this, oid);
        }
    }

    @Override
    public final synchronized void commit() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 2) {
            throw new IllegalStateException(Messages.message((String)"persist.missingPrepare"));
        }
        try {
            this._status = 8;
            this.commitConnections();
        }
        catch (Exception except) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)except), except);
        }
        Collection readWriteObjects = this._tracker.getReadWriteObjects();
        for (Object toCommit : readWriteObjects) {
            ClassMolder molder = this._tracker.getMolderForObject(toCommit);
            LockEngine engine = molder.getLockEngine();
            OID oid = this._tracker.getOIDForObject(toCommit);
            if (this._tracker.isDeleted(toCommit)) {
                engine.forgetObject(this, oid);
            } else {
                if (this._tracker.isUpdateCacheNeeded(toCommit)) {
                    engine.updateCache(this, oid, toCommit);
                }
                engine.releaseLock(this, oid);
            }
            if (this._callback != null) {
                this._callback.releasing(toCommit, true);
                continue;
            }
            if (molder.getCallback() == null) continue;
            molder.getCallback().releasing(toCommit, true);
        }
        this.txcommitted();
        this._tracker.clear();
        this._status = 3;
    }

    @Override
    public final Iterator iterateReadWriteObjectsInTransaction() {
        return this._tracker.getReadWriteObjects().iterator();
    }

    @Override
    public final synchronized void rollback() {
        if (this._status != 0 && this._status != 2 && this._status != 1) {
            throw new IllegalStateException(Messages.message((String)"persist.noTransaction"));
        }
        this.rollbackConnections();
        this._tracker.unmarkAllDeleted();
        Collection readWriteObjects = this._tracker.getReadWriteObjects();
        OID oid = null;
        try {
            for (Object object : readWriteObjects) {
                LockEngine engine = this._tracker.getMolderForObject(object).getLockEngine();
                oid = this._tracker.getOIDForObject(object);
                if (this._tracker.isCreating(object)) continue;
                engine.revertObject(this, oid, object);
            }
            for (Object object : readWriteObjects) {
                ClassMolder molder = this._tracker.getMolderForObject(object);
                LockEngine engine = molder.getLockEngine();
                oid = this._tracker.getOIDForObject(object);
                if (!this._tracker.isCreating(object)) {
                    if (this._tracker.isCreated(object)) {
                        engine.forgetObject(this, oid);
                    } else {
                        engine.releaseLock(this, oid);
                    }
                }
                if (this._callback != null) {
                    this._callback.releasing(object, false);
                    continue;
                }
                if (molder.getCallback() == null) continue;
                molder.getCallback().releasing(object, false);
            }
        }
        catch (Exception except) {
            LOG.error((Object)("Caught exception at rollback of object with OID " + oid), (Throwable)except);
        }
        this._tracker.clear();
        this.txrolledback();
        this._status = 4;
    }

    @Override
    public final synchronized void close() throws TransactionAbortedException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(Messages.message((String)"persist.missingEnd"));
        }
        try {
            this.closeConnections();
        }
        catch (Exception except) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format((String)"persist.nested", (Object)except), except);
        }
    }

    @Override
    public final boolean isCreated(Object object) {
        return this._tracker.isCreated(object);
    }

    @Override
    public final boolean isUpdateCacheNeeded(Object object) {
        return this._tracker.isUpdateCacheNeeded(object);
    }

    @Override
    public final boolean isUpdatePersistNeeded(Object object) {
        return this._tracker.isUpdatePersistNeeded(object);
    }

    @Override
    public final boolean isPersistent(Object object) {
        return this._tracker.isTracking(object) && !this._tracker.isDeleted(object);
    }

    @Override
    public final boolean isRecorded(Object object) {
        return this._tracker.isTracking(object);
    }

    @Override
    public final boolean isDepended(OID master, Object dependent) {
        OID oid = this._tracker.getOIDForObject(dependent);
        if (oid == null) {
            return false;
        }
        OID depends = oid.getDepends();
        if (depends == null) {
            return false;
        }
        return depends.equals(master);
    }

    @Override
    public final int getStatus() {
        return this._status;
    }

    @Override
    public final boolean isOpen() {
        return this._status == 0 || this._status == 1;
    }

    @Override
    public final void setWaitOnLock(ObjectLock lock) {
        this._waitOnLock = lock;
    }

    @Override
    public final ObjectLock getWaitOnLock() {
        return this._waitOnLock;
    }

    @Override
    public final boolean isDeleted(Object object) {
        return this._tracker.isDeleted(object);
    }

    @Override
    public final boolean isDeletedByOID(OID oid) {
        Object o = this._tracker.getObjectForOID(oid.getMolder().getLockEngine(), oid, false);
        if (o != null) {
            return this._tracker.isDeleted(o);
        }
        return false;
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this._db.getClassLoader();
    }

    @Override
    public final synchronized void expireCache(ClassMolder molder, Identity identity) throws PersistenceException {
        LockEngine engine = molder.getLockEngine();
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(molder, identity);
        Object trackedObject = this._tracker.getObjectForOID(engine, oid, false);
        if (trackedObject == null) {
            try {
                block6: {
                    this._tracker.trackObject(molder, oid, identity);
                    if (!engine.expireCache(this, oid, this._lockTimeout)) break block6;
                    engine.releaseLock(this, oid);
                }
                Object var8_6 = null;
                this._tracker.untrackObject(identity);
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this._tracker.untrackObject(identity);
                throw throwable;
            }
        }
    }

    @Override
    public final boolean isCached(ClassMolder molder, Class cls, Identity identity) throws PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oid = new OID(molder, identity);
        return molder.getLockEngine().isCached(cls, oid);
    }

    @Override
    public final boolean isReadOnly(Object object) {
        return this._tracker.isReadOnly(object);
    }

    @Override
    public final Database getDatabase() {
        return this._db;
    }

    @Override
    public final boolean isLocked(Class cls, Identity identity, LockEngine lockEngine) {
        OID oid = new OID(lockEngine.getClassMolder(cls), identity);
        return lockEngine.isLocked(cls, oid);
    }

    @Override
    public final String getNamedQuery(ClassMolder molder, String name) throws QueryException {
        if (molder == null) {
            throw new QueryException("Invalid argument - molder is null");
        }
        return molder.getNamedQuery(name);
    }

    @Override
    public final NamedNativeQuery getNamedNativeQuery(ClassMolder molder, String name) throws QueryException {
        if (molder == null) {
            throw new QueryException("Invalid argument - molder is null");
        }
        return molder.getNamedNativeQuery(name);
    }
}

