/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;

public final class AtomikosTransactionManagerFactory
implements TransactionManagerFactory {
    private static final Log LOG = LogFactory.getLog(AtomikosTransactionManagerFactory.class);
    public static final String MANAGER_CLASS_NAME = "com.atomikos.icatch.jta.UserTransactionManager";
    public static final String NAME = "atomikos";

    public String getName() {
        return NAME;
    }

    public TransactionManager getTransactionManager(Properties properties) throws TransactionManagerAcquireException {
        return this.getTransactionManager(MANAGER_CLASS_NAME, properties);
    }

    public TransactionManager getTransactionManager(String managerClassName, Properties properties) throws TransactionManagerAcquireException {
        TransactionManager transactionManager = null;
        try {
            Class<?> manager = Class.forName(managerClassName);
            Object obj = manager.newInstance();
            transactionManager = (TransactionManager)obj;
        }
        catch (Exception ex) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: atomikos";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        if (transactionManager == null) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: atomikos";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return transactionManager;
    }
}

