/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.jdo.engine.DatabaseContext;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.CacheManager;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.xml.NamedNativeQuery;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.InstanceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseImpl
implements Database {
    private static final String NATIVE_QUERY_PREFIX = "CALL SQL";
    private static final String NATIVE_QUERY_AS = "AS";
    protected PersistenceInfoGroup _scope;
    protected TransactionContext _ctx;
    private ArrayList<TxSynchronizable> _synchronizables;
    protected int _lockTimeout;
    protected CallbackInterceptor _callback;
    protected InstanceFactory _instanceFactory;
    protected String _dbName;
    protected boolean _autoStore;
    protected ClassLoader _classLoader;
    private CacheManager _cacheManager;

    public AbstractDatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        this._autoStore = autoStore;
        DatabaseContext context = null;
        try {
            context = DatabaseRegistry.getDatabaseContext(dbName);
        }
        catch (MappingException ex) {
            throw new DatabaseNotFoundException(Messages.format((String)"jdo.dbNoMapping", (Object)dbName));
        }
        this._scope = new PersistenceInfoGroup(new LockEngine[]{context.getEngine()});
        this._callback = callback;
        this._instanceFactory = instanceFactory;
        this._dbName = dbName;
        this._lockTimeout = lockTimeout;
        this._classLoader = classLoader;
        this.loadSynchronizables();
    }

    LockEngine getLockEngine() {
        return this._scope.getLockEngine();
    }

    @Override
    public PersistenceInfoGroup getScope() {
        return this._scope;
    }

    @Override
    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    @Override
    public boolean isAutoStore() {
        if (this._ctx != null) {
            return this._ctx.isAutoStore();
        }
        return this._autoStore;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public String getDatabaseName() {
        return this._dbName;
    }

    @Override
    public abstract void close() throws PersistenceException;

    @Override
    public boolean isClosed() {
        return this._scope == null;
    }

    @Override
    public boolean isLocked(Class cls, Object identity) throws PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        if (this._scope == null) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx.isLocked(cls, new Identity(identity), this._scope.getLockEngine());
        }
        return false;
    }

    @Override
    public <T> T load(Class<T> type, Object identity) throws PersistenceException {
        return this.load(type, identity, null, null);
    }

    @Override
    public <T> T load(Class<T> type, Object identity, Object object) throws PersistenceException {
        return this.load(type, identity, object, null);
    }

    @Override
    public <T> T load(Class<T> type, Object identity, AccessMode mode) throws PersistenceException {
        return this.load(type, identity, null, mode);
    }

    private <T> T load(Class<T> type, Object identity, Object object, AccessMode mode) throws PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        if (this._scope == null) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
        TransactionContext tx = this.getTransaction();
        ClassMolder molder = this._scope.getClassMolder(type);
        ProposedEntity proposedObject = new ProposedEntity(molder);
        if (object != null) {
            proposedObject.setEntity(object);
            proposedObject.setProposedEntityClass(object.getClass());
        }
        return (T)tx.load(new Identity(identity), proposedObject, mode);
    }

    @Override
    public void create(Object object) throws PersistenceException {
        TransactionContext tx = this.getTransaction();
        ClassMolder molder = this._scope.getClassMolder(object.getClass());
        tx.create(molder, object, null);
    }

    @Override
    public CacheManager getCacheManager() {
        if (this._cacheManager == null) {
            this._cacheManager = new CacheManager(this, this._ctx, this.getLockEngine());
        }
        return this._cacheManager;
    }

    @Override
    public void update(Object object) throws PersistenceException {
        TransactionContext tx = this.getTransaction();
        ClassMolder molder = this._scope.getClassMolder(object.getClass());
        tx.update(molder, object, null);
    }

    @Override
    public void remove(Object object) throws PersistenceException {
        TransactionContext tx = this.getTransaction();
        this._scope.getClassMolder(object.getClass());
        tx.delete(object);
    }

    @Override
    public boolean isPersistent(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message((String)"jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx.isPersistent(object);
        }
        return false;
    }

    @Override
    public Identity getIdentity(Object object) throws PersistenceException {
        if (this._scope == null) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
        ClassMolder molder = this._scope.getClassMolder(object.getClass());
        return molder.getActualIdentity(this._classLoader, object);
    }

    @Override
    public void lock(Object object) throws PersistenceException {
        if (!this.isActive()) {
            throw new TransactionNotInProgressException(Messages.message((String)"jdo.txNotInProgress"));
        }
        this._ctx.writeLock(object, this._lockTimeout);
    }

    @Override
    public OQLQuery getOQLQuery() {
        return new OQLQueryImpl(this);
    }

    @Override
    public final OQLQuery getNamedQuery(String name) throws PersistenceException {
        ClassMolder queryMolder = this._scope.findClassMolderByQuery(name);
        if (queryMolder == null) {
            queryMolder = this._scope.findClassMolderByNativeQuery(name);
            if (queryMolder != null) {
                NamedNativeQuery query = this._ctx.getNamedNativeQuery(queryMolder, name);
                String result = query.getResultClass();
                if (result == null) {
                    result = queryMolder.getName();
                }
                try {
                    return this.getNativeQuery(query.getQuery(), Class.forName(result));
                }
                catch (ClassNotFoundException ex) {
                    throw new PersistenceException("Can not find the resulting class: " + result);
                }
            }
            throw new QueryException("Cannot find a named query with the name " + name);
        }
        String oql = this._ctx.getNamedQuery(queryMolder, name);
        return this.getOQLQuery(oql);
    }

    @Override
    public final OQLQuery getNativeQuery(String sql, Class<?> result) throws PersistenceException {
        StringBuffer buff = new StringBuffer();
        buff.append(NATIVE_QUERY_PREFIX);
        buff.append(" ");
        buff.append(sql);
        buff.append(" ");
        buff.append(NATIVE_QUERY_AS);
        buff.append(" ");
        buff.append(result.getName());
        return this.getOQLQuery(buff.toString());
    }

    @Override
    public OQLQuery getOQLQuery(String oql) throws PersistenceException {
        OQLQueryImpl oqlImpl = new OQLQueryImpl(this);
        oqlImpl.create(oql);
        return oqlImpl;
    }

    @Override
    public Query getQuery() {
        return new OQLQueryImpl(this);
    }

    protected TransactionContext getTransaction() throws TransactionNotInProgressException {
        if (this._scope == null) {
            throw new TransactionNotInProgressException(Messages.message((String)"jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx;
        }
        throw new TransactionNotInProgressException(Messages.message((String)"jdo.dbTxNotInProgress"));
    }

    @Override
    public abstract void begin() throws PersistenceException;

    @Override
    public abstract void commit() throws TransactionNotInProgressException, TransactionAbortedException;

    @Override
    public abstract void rollback() throws TransactionNotInProgressException;

    @Override
    public boolean isActive() {
        return this._ctx != null && this._ctx.isOpen();
    }

    public String toString() {
        return super.toString() + ":" + this._dbName;
    }

    @Override
    public abstract Connection getJdbcConnection() throws PersistenceException;

    protected void loadSynchronizables() {
        if (this._synchronizables == null) {
            this._synchronizables = new ArrayList();
            AbstractProperties properties = CPAProperties.getInstance();
            Object[] objects = properties.getObjectArray("org.exolab.castor.persist.TxSynchronizable", properties.getApplicationClassLoader());
            if (objects != null) {
                for (int i = 0; i < objects.length; ++i) {
                    TxSynchronizable sync = (TxSynchronizable)objects[i];
                    this._synchronizables.add(sync);
                }
            }
            if (this._synchronizables.size() == 0) {
                this._synchronizables = null;
            }
        }
    }

    protected void registerSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator<TxSynchronizable> iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.addTxSynchronizable(iter.next());
            }
        }
    }

    protected void unregisterSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator<TxSynchronizable> iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.removeTxSynchronizable(iter.next());
            }
        }
    }

    public TransactionContext getCurrentTransaction() throws TransactionNotInProgressException {
        return this.getTransaction();
    }
}

