/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.persist.LocalTransactionContext;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.AbstractDatabaseImpl;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;

public class LocalDatabaseImpl
extends AbstractDatabaseImpl {
    private static Log _log = LogFactory.getFactory().getInstance(LocalDatabaseImpl.class);

    public LocalDatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        super(dbName, lockTimeout, callback, instanceFactory, classLoader, autoStore);
        this._ctx = new LocalTransactionContext(this);
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this._classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws PersistenceException {
        try {
            if (this.isActive()) {
                try {
                    this._ctx.rollback();
                }
                catch (Exception except) {
                    _log.debug((Object)"Exception at rollback of TransactionContext.");
                }
                try {
                    this._ctx.close();
                }
                catch (Exception except) {
                    _log.debug((Object)"Exception at close of TransactionContext.");
                }
                throw new PersistenceException(Messages.message((String)"jdo.dbClosedTxRolledback"));
            }
            Object var3_3 = null;
            this._scope = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this._scope = null;
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        if (this._scope != null || !this.isActive()) {
            return;
        }
        OQLQuery oqlQuery = this.getOQLQuery();
        String sql = ((OQLQueryImpl)oqlQuery).getSQL();
        _log.warn((Object)Messages.format((String)"jdo.finalize_close", (Object)this.toString(), (Object)this._dbName, (Object)sql));
        this.close();
    }

    public void begin() throws PersistenceException {
        _log.debug((Object)"Beginning tx");
        if (this.isActive()) {
            throw new PersistenceException(Messages.message((String)"jdo.txInProgress"));
        }
        this._ctx.setStatus(0);
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this.registerSynchronizables();
    }

    /*
     * Loose catch block
     */
    public void commit() throws TransactionNotInProgressException, TransactionAbortedException {
        block11: {
            _log.debug((Object)"Committing tx");
            if (!this.isActive()) {
                throw new TransactionNotInProgressException(Messages.message((String)"jdo.txNotInProgress"));
            }
            if (this._ctx.getStatus() == 1) {
                throw new TransactionAbortedException(Messages.message((String)"jdo.txRollback"));
            }
            this._ctx.prepare();
            this._ctx.commit();
            Object var3_1 = null;
            try {
                if (this._ctx.isOpen()) {
                    this._ctx.close();
                }
                break block11;
            }
            catch (Exception e) {
                _log.info((Object)e.getMessage(), (Throwable)e);
            }
            break block11;
            {
                catch (TransactionAbortedException except) {
                    _log.info((Object)Messages.format((String)"jdo.txAborted", (Object)except.getMessage()), (Throwable)((Object)except));
                    this._ctx.rollback();
                    throw except;
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    if (this._ctx.isOpen()) {
                        this._ctx.close();
                    }
                }
                catch (Exception e) {
                    _log.info((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
        }
        this.unregisterSynchronizables();
    }

    public void rollback() throws TransactionNotInProgressException {
        _log.debug((Object)"Rolling back tx");
        if (!this.isActive()) {
            throw new TransactionNotInProgressException(Messages.message((String)"jdo.txNotInProgress"));
        }
        this._ctx.rollback();
        this.unregisterSynchronizables();
    }

    public Connection getJdbcConnection() throws PersistenceException {
        if (this._ctx == null || !this._ctx.isOpen()) {
            String message = Messages.message((String)"jdo.dbTxNotInProgress.jdbc");
            throw new PersistenceException(message);
        }
        return this._ctx.getConnection(this._scope.getLockEngine());
    }
}

