/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.cpa.persistence.convertor.TypeConvertor;
import org.castor.cpa.persistence.convertor.TypeConvertorRegistry;
import org.castor.jdo.util.ClassLoadingUtils;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DbMetaInfo;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.engine.AbstractDatabaseImpl;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SimpleQueryExecutor;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.oql.Lexer;
import org.exolab.castor.jdo.oql.ParamInfo;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.ParseTreeWalker;
import org.exolab.castor.jdo.oql.Parser;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

public class OQLQueryImpl
implements Query,
OQLQuery {
    private static TypeConvertorRegistry _typeConvertorRegistry = null;
    private LockEngine _dbEngine;
    private Database _database;
    private Class _objClass;
    private ClassDescriptor _clsDesc;
    private QueryExpression _expr;
    private String _spCall;
    private Class[] _bindTypes;
    private Object[] _bindValues;
    private Hashtable<Integer, ParamInfo> _paramInfo;
    private int _fieldNum;
    private int _projectionType;
    private Vector<String> _projectionInfo;
    private PersistenceQuery _query;
    private QueryResults _results;

    OQLQueryImpl(Database database) {
        this._database = database;
    }

    private TypeConvertorRegistry getTypeConvertorRegistry() {
        if (_typeConvertorRegistry == null) {
            AbstractProperties properties = CPAProperties.getInstance();
            _typeConvertorRegistry = new TypeConvertorRegistry(properties);
        }
        return _typeConvertorRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind(Object value) {
        Object internalValue = value;
        if (this._expr == null && this._spCall == null) {
            throw new IllegalStateException("Must create query before using it");
        }
        if (this._fieldNum == this._paramInfo.size()) {
            throw new IllegalArgumentException("Only " + this._paramInfo.size() + " fields in this query");
        }
        ParamInfo info = this._paramInfo.get(new Integer(this._fieldNum + 1));
        Class paramClass = info.getTheClass();
        Class fieldClass = info.getFieldType();
        Class sqlClass = info.getSQLType();
        if (internalValue != null) {
            Class<?> valueClass = internalValue.getClass();
            if (paramClass.isAssignableFrom(valueClass)) {
                LockEngine lockEngine = ((AbstractDatabaseImpl)this._database).getLockEngine();
                ClassMolder molder = lockEngine.getClassMolder(valueClass);
                if (molder != null) {
                    Identity temp = molder.getActualIdentity(this._database.getClassLoader(), internalValue);
                    if (temp == null) {
                        internalValue = null;
                    } else {
                        if (temp.size() != 1) throw new IllegalArgumentException("Unable to bind multi column identities");
                        internalValue = temp.get(0);
                    }
                }
            } else if (info.isUserDefined()) {
                throw new IllegalArgumentException("Query paramter " + (this._fieldNum + 1) + " is not of the expected type " + paramClass + " it is an instance of the class " + valueClass);
            }
            if (sqlClass != null && !sqlClass.isAssignableFrom(valueClass)) {
                if (fieldClass != valueClass) {
                    try {
                        TypeConvertor tc = this.getTypeConvertorRegistry().getConvertor(valueClass, fieldClass, null);
                        internalValue = tc.convert(internalValue);
                    }
                    catch (MappingException e) {
                        throw new IllegalArgumentException("Query parameter " + (this._fieldNum + 1) + " cannot be converted from " + valueClass + " to " + paramClass + ", because no convertor can be found.");
                    }
                }
                if (info.getConvertor() != null) {
                    internalValue = info.getConvertor().convert(internalValue);
                }
            }
        }
        if (this._bindValues == null) {
            this._bindValues = new Object[this._bindTypes.length];
        }
        this._bindValues[this._fieldNum++] = internalValue;
        return;
    }

    public void bind(boolean value) {
        this.bind(new Boolean(value));
    }

    public void bind(short value) {
        this.bind(new Short(value));
    }

    public void bind(int value) {
        this.bind(new Integer(value));
    }

    public void bind(long value) {
        this.bind(new Long(value));
    }

    public void bind(float value) {
        this.bind(new Float(value));
    }

    public void bind(double value) {
        this.bind(new Double(value));
    }

    public void create(String oql) throws PersistenceException {
        this._fieldNum = 0;
        this._expr = null;
        this._spCall = null;
        if (oql.startsWith("CALL ")) {
            this.createCall(oql);
            return;
        }
        Lexer lexer = new Lexer(oql);
        Parser parser = new Parser(lexer);
        ParseTreeNode parseTree = parser.getParseTree();
        this._dbEngine = ((AbstractDatabaseImpl)this._database).getLockEngine();
        if (this._dbEngine == null) {
            throw new QueryException("Could not get a persistence engine");
        }
        TransactionContext trans = ((AbstractDatabaseImpl)this._database).getTransaction();
        DbMetaInfo dbInfo = trans.getConnectionInfo(this._dbEngine);
        ParseTreeWalker walker = new ParseTreeWalker(this._dbEngine, parseTree, this._database.getClassLoader(), dbInfo);
        this._objClass = walker.getObjClass();
        this._clsDesc = walker.getClassDescriptor();
        this._expr = walker.getQueryExpression();
        this._paramInfo = walker.getParamInfo();
        this._projectionType = walker.getProjectionType();
        this._projectionInfo = walker.getProjectionInfo();
        this._bindTypes = new Class[this._paramInfo.size()];
        int paramIndex = 0;
        Enumeration<ParamInfo> e = this._paramInfo.elements();
        while (e.hasMoreElements()) {
            ParamInfo info = e.nextElement();
            this._bindTypes[paramIndex++] = info.getSQLType() == null ? info.getTheClass() : info.getSQLType();
        }
    }

    public void createCall(String oql) throws QueryException {
        int i;
        ParamInfo info;
        Integer paramNo;
        StringBuffer sb;
        if (!oql.startsWith("CALL ")) {
            throw new QueryException("Stored procedure call must start with CALL");
        }
        int as = oql.lastIndexOf(" AS ");
        if (as < 0) {
            throw new QueryException("Stored procedure call must end with \"AS <class-name>\"");
        }
        int leftParen = oql.indexOf("(");
        int rightParen = oql.indexOf(")");
        StringBuffer sql = new StringBuffer();
        int paramCnt = 0;
        this._paramInfo = new Hashtable();
        if (oql.startsWith("CALL SQL")) {
            int startOff = oql.toUpperCase().indexOf("WHERE ");
            if (startOff >= 0) {
                sql.append(oql.substring(5, startOff += 6));
                int i2 = startOff;
                while (i2 < as) {
                    if (oql.charAt(i2) == '$') {
                        char c;
                        sb = new StringBuffer();
                        for (int j = i2 + 1; j < as && Character.isDigit(c = oql.charAt(j)); ++j) {
                            sb.append(c);
                        }
                        sql.append('?');
                        if (sb.length() > 0) {
                            sql.append(sb);
                            paramNo = Integer.valueOf(sb.toString());
                        } else {
                            paramNo = new Integer(paramCnt + 1);
                        }
                        info = this._paramInfo.get(paramNo);
                        if (info == null) {
                            info = new ParamInfo("", "java.lang.Object", null, this._database.getClassLoader());
                        }
                        this._paramInfo.put(paramNo, info);
                        ++paramCnt;
                        i2 += sb.length() + 1;
                        continue;
                    }
                    sql.append(oql.charAt(i2));
                    ++i2;
                }
            } else {
                sql.append(oql.substring(5, as));
            }
        } else if (leftParen < 0 && rightParen < 0) {
            sql.append(oql.substring(5, as));
        } else {
            if (leftParen < 0 && rightParen >= 0 || leftParen > rightParen) {
                throw new QueryException("Syntax error: parenthesis");
            }
            sql.append(oql.substring(5, leftParen));
            sql.append('(');
            for (i = leftParen + 1; i < rightParen; ++i) {
                char c;
                if (oql.charAt(i) != '$') continue;
                sb = new StringBuffer();
                for (int j = i + 1; j < rightParen && Character.isDigit(c = oql.charAt(j)); ++j) {
                    sb.append(c);
                }
                paramNo = sb.length() > 0 ? Integer.valueOf(sb.toString()) : new Integer(paramCnt + 1);
                info = this._paramInfo.get(paramNo);
                if (info == null) {
                    info = new ParamInfo("", "java.lang.Object", null, this._database.getClassLoader());
                }
                this._paramInfo.put(paramNo, info);
                ++paramCnt;
            }
            for (i = 0; i < paramCnt; ++i) {
                sql.append('?');
                if (i >= paramCnt - 1) continue;
                sql.append(',');
            }
            sql.append(')');
        }
        this._spCall = sql.toString();
        this._projectionType = 3;
        this._bindTypes = new Class[paramCnt];
        for (i = 0; i < paramCnt; ++i) {
            this._bindTypes[i] = Object.class;
        }
        String objType = oql.substring(as + 4).trim();
        if (objType.length() == 0) {
            throw new QueryException("Missing object name");
        }
        try {
            this._objClass = ClassLoadingUtils.loadClass(this._database.getClassLoader(), objType);
        }
        catch (ClassNotFoundException except) {
            throw new QueryException("Could not find class " + objType);
        }
        this._dbEngine = ((AbstractDatabaseImpl)this._database).getLockEngine();
        if (this._dbEngine == null || this._dbEngine.getPersistence(this._objClass) == null) {
            throw new QueryException("Could not find an engine supporting class " + objType);
        }
    }

    public QueryResults execute() throws PersistenceException {
        return this.execute(null);
    }

    public QueryResults execute(boolean scrollable) throws PersistenceException {
        return this.execute(null, scrollable);
    }

    public QueryResults execute(AccessMode accessMode) throws PersistenceException {
        return this.execute(accessMode, false);
    }

    public QueryResults execute(AccessMode accessMode, boolean scrollable) throws PersistenceException {
        if (this._expr == null && this._spCall == null) {
            throw new IllegalStateException("Must create query before using it");
        }
        if (this._results != null) {
            this._results.close();
        }
        switch (this._projectionType) {
            case 3: 
            case 4: 
            case 5: {
                try {
                    SQLEngine engine = (SQLEngine)this._dbEngine.getPersistence(this._objClass);
                    this._query = this._expr != null ? engine.createQuery(this._expr, this._bindTypes, accessMode) : engine.createCall(this._spCall, this._bindTypes);
                    if (this._bindValues != null) {
                        for (int i = 0; i < this._bindValues.length; ++i) {
                            this._query.setParameter(i, this._bindValues[i]);
                        }
                    }
                }
                catch (QueryException except) {
                    throw new QueryException(except.getMessage());
                }
                org.exolab.castor.persist.QueryResults results = ((AbstractDatabaseImpl)this._database).getTransaction().query(this._dbEngine, this._query, accessMode, scrollable);
                this._fieldNum = 0;
                if (this._projectionType == 3) {
                    this._results = new OQLEnumeration(results);
                    break;
                }
                this._results = new OQLEnumeration(results, this._projectionInfo, this._clsDesc);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                try {
                    TransactionContext tx = ((AbstractDatabaseImpl)this._database).getTransaction();
                    Connection conn = tx.getConnection(this._dbEngine);
                    SimpleQueryExecutor sqe = new SimpleQueryExecutor(this._database);
                    this._results = sqe.execute(conn, this._expr, this._bindValues);
                }
                catch (QueryException except) {
                    throw new QueryException(Messages.message((String)"persist.simple.query.failed"), (Throwable)((Object)except));
                }
                this._fieldNum = 0;
                break;
            }
            default: {
                throw new PersistenceException("Unknown projection type: " + this._projectionType);
            }
        }
        return this._results;
    }

    public String getSQL() throws QueryException {
        if (this._expr != null) {
            return this._expr.getStatement(true);
        }
        return this._spCall;
    }

    public void close() {
        if (this._query != null) {
            this._query.close();
            this._query = null;
        }
        if (this._results != null) {
            this._results.close();
            this._results = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OQLEnumeration
    implements QueryResults,
    Enumeration<Object> {
        private Object _lastObject;
        private Vector<String> _pathInfo;
        private ClassDescriptor _classDescriptor;
        private org.exolab.castor.persist.QueryResults _results;

        OQLEnumeration(org.exolab.castor.persist.QueryResults results, Vector<String> pathInfo, ClassDescriptor clsDesc) {
            this._results = results;
            this._pathInfo = pathInfo;
            this._classDescriptor = clsDesc;
        }

        OQLEnumeration(org.exolab.castor.persist.QueryResults results) {
            this._results = results;
            this._pathInfo = null;
            this._classDescriptor = null;
        }

        @Override
        public boolean absolute(int row) throws PersistenceException {
            return this._results.absolute(row);
        }

        @Override
        public int size() throws PersistenceException {
            return this._results.size();
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore(true);
            }
            catch (PersistenceException except) {
                return false;
            }
        }

        @Override
        public boolean hasMore() throws PersistenceException {
            return this.hasMore(false);
        }

        public boolean hasMore(boolean skipError) throws PersistenceException {
            block9: {
                if (this._lastObject != null) {
                    return true;
                }
                if (this._results == null) {
                    return false;
                }
                try {
                    Object identity = this._results.nextIdentity();
                    while (identity != null) {
                        try {
                            this._lastObject = this._results.fetch();
                            if (this._lastObject == null) continue;
                            break;
                        }
                        catch (ObjectNotFoundException except) {
                            identity = this._results.nextIdentity();
                        }
                        catch (PersistenceException except) {
                            identity = this._results.nextIdentity();
                            if (skipError) continue;
                            throw except;
                        }
                    }
                    if (identity == null) {
                        this._results.close();
                        this._results = null;
                    }
                }
                catch (PersistenceException except) {
                    this._results.close();
                    this._results = null;
                    if (skipError) break block9;
                    throw except;
                }
            }
            return this._lastObject != null;
        }

        @Override
        public Object nextElement() throws NoSuchElementException {
            try {
                return this.next(true);
            }
            catch (PersistenceException except) {
                return null;
            }
        }

        @Override
        public Object next() throws PersistenceException, NoSuchElementException {
            return this.next(false);
        }

        /*
         * Exception decompiling
         */
        private Object next(boolean skipError) throws PersistenceException, NoSuchElementException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void close() {
            if (this._results != null) {
                this._results.close();
                this._results = null;
            }
        }

        private Object followPath(Object parent) {
            ClassDescriptor curClassDesc = this._classDescriptor;
            Object curObject = parent;
            for (int i = 1; i < this._pathInfo.size(); ++i) {
                String curFieldName = this._pathInfo.elementAt(i);
                try {
                    ClassDescriptorJDONature nature = new ClassDescriptorJDONature((PropertyHolder)curClassDesc);
                    FieldDescriptor curFieldDesc = nature.getField(curFieldName);
                    FieldHandler handler = curFieldDesc.getHandler();
                    curObject = handler.getValue(curObject);
                    curClassDesc = curFieldDesc.getClassDescriptor();
                    continue;
                }
                catch (Exception ex) {
                    throw new NoSuchElementException("An exception was thrown trying to access get methods to follow the path expression. " + ex.toString());
                }
            }
            return curObject;
        }
    }
}

