/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.io.Serializable;
import java.util.ArrayList;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.spi.Identity;

public final class OID
implements Serializable {
    private static final long serialVersionUID = 419512942519592363L;
    private final Identity _identity;
    private final String _name;
    private final transient ClassMolder _molder;
    private final OID _depends;
    private boolean _dbLock;
    private final int _hashCode;
    private String _topClassName;
    private String[] _superClassNames;

    private OID() {
        this._identity = null;
        this._name = null;
        this._molder = null;
        this._depends = null;
        this._hashCode = 0;
    }

    public OID(ClassMolder molder, Identity identity) {
        this(molder, null, identity);
    }

    public OID(ClassMolder molder, OID depends, Identity identity) {
        ClassMolder internalMolder = molder;
        ArrayList<String> superClassNames = null;
        if (internalMolder == null) {
            throw new IllegalArgumentException("molder can't be null");
        }
        this._molder = internalMolder;
        this._identity = identity;
        this._name = internalMolder.getName();
        this._depends = depends;
        while (internalMolder.getExtends() != null) {
            if (superClassNames == null) {
                superClassNames = new ArrayList<String>();
            }
            internalMolder = internalMolder.getExtends();
            superClassNames.add(internalMolder.getName());
        }
        this._topClassName = internalMolder.getName();
        if (superClassNames != null) {
            this._superClassNames = new String[superClassNames.size()];
            superClassNames.toArray(this._superClassNames);
        }
        this._hashCode = this._topClassName.hashCode() + (this._identity == null ? 0 : this._identity.hashCode());
    }

    public OID getDepends() {
        return this._depends;
    }

    public ClassMolder getMolder() {
        return this._molder;
    }

    void setDbLock(boolean dbLock) {
        this._dbLock = dbLock;
    }

    public boolean isDbLock() {
        return this._dbLock;
    }

    public Identity getIdentity() {
        return this._identity;
    }

    String getName() {
        return this._name;
    }

    String getTopClassName() {
        return this._topClassName;
    }

    String[] getSuperClassNames() {
        return this._superClassNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        OID other = (OID)obj;
        return this._topClassName.equals(other._topClassName) && this._identity != null && this._identity.equals(other._identity);
    }

    public String toString() {
        return this._name + "/" + (this._identity == null ? "<new>" : this._identity.toString());
    }

    public int hashCode() {
        return this._hashCode;
    }
}

