/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.castor.core.util.AbstractProperties;
import org.castor.cpa.CPAProperties;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class PersistenceFactoryRegistry {
    private static Hashtable<String, PersistenceFactory> _factories;

    public static PersistenceFactory getPersistenceFactory(String name) {
        PersistenceFactoryRegistry.load();
        return _factories.get(name);
    }

    public static String[] getFactoryNames() {
        PersistenceFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration<String> enumeration = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = enumeration.nextElement();
        }
        return names;
    }

    private static synchronized void load() {
        if (_factories == null) {
            _factories = new Hashtable();
            AbstractProperties properties = CPAProperties.getInstance();
            Object[] objects = properties.getObjectArray("org.castor.cpa.persistence.sql.driver.factories", properties.getApplicationClassLoader());
            for (int i = 0; i < objects.length; ++i) {
                PersistenceFactory factory = (PersistenceFactory)objects[i];
                _factories.put(factory.getFactoryName(), factory);
            }
        }
    }

    private PersistenceFactoryRegistry() {
    }
}

