/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractCacheFactory;
import org.castor.cache.distributed.CoherenceCache;

public final class CoherenceCacheFactory
extends AbstractCacheFactory {
    private static final Log LOG = LogFactory.getLog(CoherenceCacheFactory.class);

    public String getCacheType() {
        return "coherence";
    }

    public String getCacheClassName() {
        return CoherenceCache.class.getName();
    }

    public void shutdown() {
        this.shutdown("com.tangosol.net.CacheFactory");
    }

    public synchronized void shutdown(String implementation) {
        if (!this.isInitialized()) {
            return;
        }
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            if (cls != null) {
                Method method = cls.getMethod("shutdown", null);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Problem shutting down Coherence cluster member", (Throwable)e);
        }
    }
}

