/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.castor.cache.hashbelt.container.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastIteratingContainer
implements Container {
    private Map<Object, Object> _container = new ConcurrentHashMap<Object, Object>();
    private List<Object> _keys = new ArrayList<Object>();
    private List<Object> _values = new ArrayList<Object>();
    private long _timestamp = 0L;

    @Override
    public void updateTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public synchronized Iterator<Object> keyIterator() {
        return new ArrayList<Object>(this._keys).iterator();
    }

    @Override
    public synchronized Iterator<Object> valueIterator() {
        return new ArrayList<Object>(this._values).iterator();
    }

    @Override
    public int size() {
        return this._container.size();
    }

    @Override
    public boolean isEmpty() {
        return this._container.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._container.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._container.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this._container.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Object oldValue = this._container.put(key, value);
        if (oldValue == null) {
            FastIteratingContainer fastIteratingContainer = this;
            synchronized (fastIteratingContainer) {
                this._keys.add(key);
                this._values.add(value);
            }
        }
        if (oldValue != value) {
            FastIteratingContainer fastIteratingContainer = this;
            synchronized (fastIteratingContainer) {
                this._values.remove(oldValue);
                this._values.add(value);
            }
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Object oldValue = this._container.remove(key);
        if (oldValue != null) {
            FastIteratingContainer fastIteratingContainer = this;
            synchronized (fastIteratingContainer) {
                this._keys.remove(key);
                this._values.remove(oldValue);
            }
        }
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this._container.clear();
        FastIteratingContainer fastIteratingContainer = this;
        synchronized (fastIteratingContainer) {
            this._keys.clear();
            this._values.clear();
        }
    }

    @Override
    public Set<Object> keySet() {
        return this._container.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this._container.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this._container.entrySet();
    }
}

