/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt.container;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.castor.cache.hashbelt.container.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeakReferenceContainer
implements Container {
    private HashMap<Object, WeakReference<Object>> _container = new HashMap();
    private long _timestamp = 0L;

    @Override
    public void updateTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public synchronized Iterator<Object> keyIterator() {
        return new ArrayList<Object>(this.keySet()).iterator();
    }

    @Override
    public Iterator<Object> valueIterator() {
        return this.values().iterator();
    }

    @Override
    public synchronized int size() {
        return this._container.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this._container.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this._container.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        Iterator<Map.Entry<Object, WeakReference<Object>>> iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, WeakReference<Object>> entry = iter.next();
            WeakReference<Object> ref = entry.getValue();
            Object found = ref.get();
            if (found != null) {
                if (!found.equals(value)) continue;
                return true;
            }
            iter.remove();
        }
        return false;
    }

    @Override
    public synchronized Object get(Object key) {
        WeakReference<Object> ref = this._container.get(key);
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return found;
        }
        this._container.remove(key);
        return null;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        WeakReference<Object> ref = this._container.put(key, new WeakReference<Object>(value));
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return found;
        }
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        WeakReference<Object> ref = this._container.remove(key);
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return found;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            this._container.put(entry.getKey(), new WeakReference<Object>(entry.getValue()));
        }
    }

    @Override
    public synchronized void clear() {
        this._container.clear();
    }

    @Override
    public synchronized Set<Object> keySet() {
        return this._container.keySet();
    }

    @Override
    public synchronized Collection<Object> values() {
        ArrayList<Object> col = new ArrayList<Object>();
        Iterator<Map.Entry<Object, WeakReference<Object>>> iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, WeakReference<Object>> entry = iter.next();
            WeakReference<Object> ref = entry.getValue();
            Object found = ref.get();
            if (found != null) {
                col.add(found);
                continue;
            }
            iter.remove();
        }
        return col;
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        HashMap map = new HashMap();
        Iterator<Map.Entry<Object, WeakReference<Object>>> iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, WeakReference<Object>> entry = iter.next();
            WeakReference<Object> ref = entry.getValue();
            Object found = ref.get();
            if (found != null) {
                map.put(entry.getKey(), found);
                continue;
            }
            iter.remove();
        }
        return map.entrySet();
    }
}

