/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.info;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.castor.cpa.jpa.info.GeneratorNameAlreadyUsedException;
import org.castor.cpa.jpa.info.JPAKeyGeneratorDescriptor;
import org.castor.cpa.jpa.info.JPATableGeneratorDescriptor;

public class JPAKeyGeneratorManager {
    private Map<String, JPAKeyGeneratorDescriptor> generators = new ConcurrentHashMap<String, JPAKeyGeneratorDescriptor>();
    public static final String AUTO_GENERATOR_NAME = "AUTO";

    public static JPAKeyGeneratorManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(String name, JPAKeyGeneratorDescriptor descriptor) throws GeneratorNameAlreadyUsedException {
        if (this.generators.containsKey(name)) {
            throw new GeneratorNameAlreadyUsedException();
        }
        this.generators.put(name, descriptor);
    }

    public boolean contains(String name) {
        return this.generators.containsKey(name);
    }

    public JPAKeyGeneratorDescriptor get(String name) {
        return this.generators.get(name);
    }

    public void reset() {
        this.generators.clear();
    }

    public boolean isEmpty() {
        return this.generators.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPAKeyGeneratorDescriptor getAuto() {
        if (!this.contains(AUTO_GENERATOR_NAME)) {
            Map<String, JPAKeyGeneratorDescriptor> map = this.generators;
            synchronized (map) {
                JPATableGeneratorDescriptor autoDescriptor = new JPATableGeneratorDescriptor();
                try {
                    this.add(AUTO_GENERATOR_NAME, autoDescriptor);
                }
                catch (GeneratorNameAlreadyUsedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.get(AUTO_GENERATOR_NAME);
    }

    private static class SingletonHolder {
        private static final JPAKeyGeneratorManager INSTANCE = new JPAKeyGeneratorManager();

        private SingletonHolder() {
        }
    }
}

