/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.info;

import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.castor.cpa.jpa.info.JPAKeyGeneratorDescriptor;
import org.castor.cpa.jpa.info.JPAUniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPATableGeneratorDescriptor
extends JPAKeyGeneratorDescriptor {
    private String pkColumnName;
    private String pkColumnValue;
    private String schema;
    private String table;
    private JPAUniqueConstraint[] uniqueConstraints;
    private String valueColumnName;
    private Class<?> primaryKeyType;

    public static JPATableGeneratorDescriptor extract(TableGenerator tableGenerator) {
        JPATableGeneratorDescriptor descriptor = new JPATableGeneratorDescriptor();
        descriptor.setAllocationSize(tableGenerator.allocationSize());
        descriptor.setInitialValue(tableGenerator.initialValue());
        descriptor.setName(tableGenerator.name());
        descriptor.setPkColumnName(tableGenerator.pkColumnName());
        descriptor.setPkColumnValue(tableGenerator.pkColumnValue());
        descriptor.setSchema(tableGenerator.schema());
        descriptor.setTable(tableGenerator.table());
        JPAUniqueConstraint[] constraints = JPATableGeneratorDescriptor.extractConstraints(tableGenerator);
        descriptor.setUniqueConstraints(constraints);
        descriptor.setValueColumnName(tableGenerator.valueColumnName());
        return descriptor;
    }

    private static JPAUniqueConstraint[] extractConstraints(TableGenerator tableGenerator) {
        JPAUniqueConstraint[] constraints = new JPAUniqueConstraint[]{};
        int i = 0;
        for (UniqueConstraint uniqueConstraint : tableGenerator.uniqueConstraints()) {
            constraints[i++] = JPAUniqueConstraint.extract(uniqueConstraint);
        }
        return constraints;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public void setPkColumnName(String pkColumnName) {
        this.pkColumnName = pkColumnName;
    }

    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    public void setPkColumnValue(String pkColumnValue) {
        this.pkColumnValue = pkColumnValue;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public JPAUniqueConstraint[] getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void setUniqueConstraints(JPAUniqueConstraint[] uniqueConstraints) {
        this.uniqueConstraints = uniqueConstraints;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public Class<?> getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    public void setPrimaryKeyType(Class<?> primaryKeyType) {
        this.primaryKeyType = primaryKeyType;
    }
}

