/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.natures.JPAFieldNature;
import org.castor.cpa.jpa.processors.BaseJPAAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAJoinTableProcessor
extends BaseJPAAnnotationProcessor {
    private static Log _log = LogFactory.getFactory().getInstance(JPAJoinTableProcessor.class);

    public Class<? extends Annotation> forAnnotationClass() {
        return JoinTable.class;
    }

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) throws AnnotationTargetException {
        if (info instanceof JPAFieldNature && annotation instanceof JoinTable && (target instanceof Field || target instanceof Method)) {
            _log.debug((Object)("processing field annotation " + ((Object)annotation).toString()));
            boolean targetValid = false;
            if (target.getAnnotation(OneToMany.class) != null) {
                targetValid = true;
            }
            if (target.getAnnotation(ManyToMany.class) != null) {
                targetValid = true;
            }
            if (!targetValid) {
                _log.error((Object)("JoinTable annotation on " + ((Member)((Object)target)).getName() + " is not valid! Needs a ManyToMany or unidiretional OneToMany " + "relationship annotation! Ignoring @JoinTable!"));
                return false;
            }
            JPAFieldNature jpaFieldNature = (JPAFieldNature)info;
            JoinTable joinTable = (JoinTable)annotation;
            jpaFieldNature.setJoinTableName(joinTable.name());
            jpaFieldNature.setJoinTableCatalog(joinTable.catalog());
            jpaFieldNature.setJoinTableSchema(joinTable.schema());
            jpaFieldNature.setJoinTableJoinColumns(joinTable.joinColumns());
            jpaFieldNature.setJoinTableInverseJoinColumns(joinTable.inverseJoinColumns());
            if (joinTable.catalog().length() != 0) {
                _log.warn((Object)"Castor does not support catalog definition for tables. Use global definition.");
            }
            if (joinTable.schema().length() != 0) {
                _log.warn((Object)"Castor does not support schema definition for tables. Use global definition.");
            }
            if (joinTable.uniqueConstraints().length != 0) {
                _log.warn((Object)"Castor does not support unique constraint definition for tables.");
            }
        }
        return false;
    }
}

