/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.natures.JPAFieldNature;
import org.castor.cpa.jpa.processors.BaseJPAAnnotationProcessor;
import org.castor.cpa.jpa.processors.ReflectionsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAOneToManyProcessor
extends BaseJPAAnnotationProcessor {
    private static Log _log = LogFactory.getFactory().getInstance(JPAOneToManyProcessor.class);

    public Class<? extends Annotation> forAnnotationClass() {
        return OneToMany.class;
    }

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) throws AnnotationTargetException {
        if (info instanceof JPAFieldNature && annotation instanceof OneToMany && (target instanceof Method || target instanceof Field)) {
            Class<?> collectionType;
            _log.debug((Object)("processing field annotation " + ((Object)annotation).toString()));
            JPAFieldNature jpaFieldNature = (JPAFieldNature)info;
            OneToMany oneToMany = (OneToMany)annotation;
            try {
                collectionType = ReflectionsHelper.getCollectionType(target, true);
            }
            catch (AnnotationTargetException e) {
                _log.error((Object)e.getMessage());
                throw e;
            }
            Class<?> targetEntity = oneToMany.targetEntity();
            if (Void.TYPE.equals(targetEntity)) {
                try {
                    targetEntity = ReflectionsHelper.getTargetEntityFromGenerics(target);
                    if (targetEntity == null) {
                        String className = ((Member)((Object)target)).getDeclaringClass().getName();
                        String targetName = ((Member)((Object)target)).getName();
                        String message = "Target entity for OneToMany relation on " + className + "#" + targetName + " not specified - use generics or specify targetEntity!";
                        throw new AnnotationTargetException(message);
                    }
                }
                catch (AnnotationTargetException e) {
                    _log.error((Object)e.getMessage());
                    throw e;
                }
            }
            jpaFieldNature.setRelationTargetEntity(targetEntity);
            jpaFieldNature.setRelationCollectionType(collectionType);
            if (oneToMany.cascade().length > 0) {
                jpaFieldNature.setCascadeTypes(oneToMany.cascade());
            }
            jpaFieldNature.setRelationLazyFetch(false);
            if (oneToMany.fetch() == FetchType.LAZY) {
                jpaFieldNature.setRelationLazyFetch(true);
            }
            if (oneToMany.mappedBy().length() != 0) {
                jpaFieldNature.setRelationMappedBy(oneToMany.mappedBy());
            }
            jpaFieldNature.setOneToMany(true);
            return true;
        }
        return false;
    }
}

