/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.convertor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.castor.core.util.AbstractProperties;
import org.castor.cpa.persistence.convertor.TypeConvertor;
import org.exolab.castor.mapping.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConvertorRegistry {
    private final Map<Class<?>, Map<Class<?>, TypeConvertor>> _convertors = new HashMap();

    public TypeConvertorRegistry(AbstractProperties properties) {
        Object[] objects = properties.getObjectArray("org.castor.cpa.persistence.TypeConvertors", properties.getApplicationClassLoader());
        for (int i = 0; i < objects.length; ++i) {
            TypeConvertor convertor = (TypeConvertor)objects[i];
            convertor.configure(properties);
            this.putConvertor(convertor.fromType(), convertor.toType(), convertor);
        }
    }

    private void putConvertor(Class<?> fromType, Class<?> toType, TypeConvertor convertor) {
        Map<Class<?>, TypeConvertor> convertors = this._convertors.get(fromType);
        if (convertors == null) {
            convertors = new HashMap();
            this._convertors.put(fromType, convertors);
        }
        convertors.put(toType, convertor);
    }

    private TypeConvertor getConvertor(Class<?> fromType, Class<?> toType) throws MappingException {
        TypeConvertor convertor = null;
        Map<Class<?>, TypeConvertor> convertors = this._convertors.get(fromType);
        if (convertors != null) {
            convertor = convertors.get(toType);
        }
        if (convertor == null) {
            Iterator<Map.Entry<Class<?>, Map<Class<?>, TypeConvertor>>> fromIter = this._convertors.entrySet().iterator();
            while (convertor == null && fromIter.hasNext()) {
                Map.Entry<Class<?>, Map<Class<?>, TypeConvertor>> fromEntry = fromIter.next();
                if (!fromEntry.getKey().isAssignableFrom(fromType)) continue;
                convertors = fromEntry.getValue();
                Iterator<Map.Entry<Class<?>, TypeConvertor>> toIter = convertors.entrySet().iterator();
                while (convertor == null && toIter.hasNext()) {
                    Map.Entry<Class<?>, TypeConvertor> toEntry = toIter.next();
                    if (!toEntry.getKey().isAssignableFrom(toType)) continue;
                    convertor = toEntry.getValue();
                }
            }
            if (convertor == null) {
                throw new MappingException("mapping.noConvertor", (Object)fromType.getName(), (Object)toType.getName());
            }
            this.putConvertor(fromType, toType, convertor);
        }
        return convertor;
    }

    public TypeConvertor getConvertor(Class<?> fromType, Class<?> toType, String parameter) throws MappingException {
        TypeConvertor convertor = this.getConvertor(fromType, toType);
        if (parameter != null) {
            convertor = (TypeConvertor)convertor.clone();
            convertor.parameterize(parameter);
        }
        return convertor;
    }
}

