/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.connection.ConnectionFactory;
import org.castor.cpa.persistence.sql.connection.ConnectionProxyFactory;
import org.castor.jdo.conf.Jndi;
import org.exolab.castor.mapping.MappingException;

public final class JNDIConnectionFactory
implements ConnectionFactory {
    private static final Log LOG = LogFactory.getLog(JNDIConnectionFactory.class);
    private final Jndi _jndi;
    private final boolean _useProxies;
    private DataSource _dataSource = null;

    public JNDIConnectionFactory(Jndi jndi, boolean useProxies) {
        this._jndi = jndi;
        this._useProxies = useProxies;
    }

    public void initializeFactory() throws MappingException {
        Object dataSource;
        String name = this._jndi.getName();
        try {
            InitialContext initialContext = new InitialContext();
            dataSource = initialContext.lookup(name);
        }
        catch (NameNotFoundException e) {
            String msg = Messages.format((String)"jdo.jndiNameNotFound", (Object)name);
            LOG.error((Object)msg, (Throwable)e);
            throw new MappingException(msg, (Exception)e);
        }
        catch (NamingException e) {
            throw new MappingException((Exception)e);
        }
        if (!(dataSource instanceof DataSource)) {
            String msg = Messages.format((String)"jdo.jndiNameNotFound", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        this._dataSource = (DataSource)dataSource;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using DataSource from JNDI ENC: " + name));
        }
    }

    public Connection createConnection() throws SQLException {
        Connection connection = this._dataSource.getConnection();
        if (!this._useProxies) {
            return connection;
        }
        return ConnectionProxyFactory.newConnectionProxy(connection, this.getClass().getName());
    }
}

