/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.cpa.persistence.sql.keygen.KeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorFactory;
import org.castor.cpa.persistence.sql.keygen.KeyGeneratorFactoryRegistry;
import org.castor.cpa.persistence.sql.keygen.NoKeyGeneratorFactory;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFactory
implements PersistenceFactory {
    private static final Log LOG = LogFactory.getLog(BaseFactory.class);
    private final KeyGeneratorFactoryRegistry _keyGeneratorFactoryRegistry;
    private final Map<ClassDescriptor, KeyGenerator> _classDescriptorToKeyGenerator = new HashMap<ClassDescriptor, KeyGenerator>();
    private final Map<ClassDescriptor, Persistence> _classDescriptorToPersistence = new HashMap<ClassDescriptor, Persistence>();

    public BaseFactory() {
        AbstractProperties properties = CPAProperties.getInstance();
        this._keyGeneratorFactoryRegistry = new KeyGeneratorFactoryRegistry(properties);
    }

    @Override
    public KeyGenerator getKeyGenerator(ClassDescriptor clsDesc) throws MappingException {
        KeyGenerator keyGen = this._classDescriptorToKeyGenerator.get(clsDesc);
        if (keyGen == null) {
            int sqlType;
            KeyGeneratorDescriptor keyGenDesc = new ClassDescriptorJDONature((PropertyHolder)clsDesc).getKeyGeneratorDescriptor();
            FieldDescriptor fldDesc = clsDesc.getIdentity();
            int[] sqlTypes = new FieldDescriptorJDONature((PropertyHolder)fldDesc).getSQLType();
            int n = sqlType = sqlTypes == null ? 0 : sqlTypes[0];
            if (clsDesc.getExtends() == null && keyGenDesc != null) {
                String keyGenFactoryName = keyGenDesc.getKeyGeneratorFactoryName();
                KeyGeneratorFactory keyGenFactory = this._keyGeneratorFactoryRegistry.getKeyGeneratorFactory(keyGenFactoryName);
                if (keyGenFactory == null) {
                    String msg = Messages.format((String)"mapping.noKeyGen", (Object)keyGenFactoryName);
                    LOG.warn((Object)msg);
                    throw new MappingException(msg);
                }
                Properties keyGenParams = keyGenDesc.getParams();
                keyGen = keyGenFactory.getKeyGenerator(this, keyGenParams, sqlType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key generator " + keyGenFactoryName + " has been instantiated, parameters: " + keyGenParams));
                }
            } else {
                NoKeyGeneratorFactory noKeyGenFac = new NoKeyGeneratorFactory();
                keyGen = noKeyGenFac.getKeyGenerator(this, null, sqlType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Key generator " + noKeyGenFac.getKeyGeneratorName() + " has been instantiated"));
                }
            }
            this._classDescriptorToKeyGenerator.put(clsDesc, keyGen);
        }
        return keyGen;
    }

    @Override
    public Persistence getPersistence(ClassDescriptor clsDesc) {
        if (!clsDesc.hasNature(ClassDescriptorJDONature.class.getName())) {
            return null;
        }
        try {
            Persistence sqlEngine = this._classDescriptorToPersistence.get(clsDesc);
            if (sqlEngine == null) {
                sqlEngine = new SQLEngine(clsDesc, this);
                this._classDescriptorToPersistence.put(clsDesc, sqlEngine);
            }
            return sqlEngine;
        }
        catch (MappingException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.fatalException", (Object)((Object)except)));
            return null;
        }
    }

    @Override
    public PersistenceQuery getCallQuery(String call, Class<?>[] paramTypes, Class<?> javaClass, String[] fields, int[] sqlTypes) {
        return null;
    }

    @Override
    public Class<?> adjustSqlType(Class<?> sqlType) {
        return sqlType;
    }
}

