/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.driver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.castor.cpa.persistence.sql.driver.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class HsqlQueryExpression
extends JDBCQueryExpression {
    public HsqlQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        int j;
        String tableName;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._limit != null) {
            if (this._offset != null) {
                sql.append(" LIMIT ");
                sql.append(this._offset).append(" ");
                sql.append(this._limit).append(" ");
            } else {
                sql.append(" TOP ").append(this._limit).append(" ");
            }
        }
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        if (this._select == null) {
            sql.append(this.getColumnList());
        } else {
            sql.append(this._select).append(" ");
        }
        sql.append(" FROM ");
        Hashtable tables = new Hashtable(this._tables);
        Vector<String> done = new Vector<String>();
        boolean first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (!join._outer || done.contains(join._leftTable)) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            sql.append(this._factory.quoteName(join._leftTable));
            sql.append(" LEFT OUTER JOIN ");
            tableName = (String)tables.get(join._rightTable);
            if (join._rightTable.equals(tableName)) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(join._rightTable));
            }
            sql.append(" ON ");
            for (j = 0; j < join._leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j])).append("=");
                sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
            }
            tables.remove(join._leftTable);
            tables.remove(join._rightTable);
            for (int k = i + 1; k < this._joins.size(); ++k) {
                JDBCQueryExpression.Join join2 = (JDBCQueryExpression.Join)this._joins.elementAt(k);
                if (!join2._outer || !join._leftTable.equals(join2._leftTable)) continue;
                sql.append(" LEFT OUTER JOIN ");
                tableName = (String)tables.get(join2._rightTable);
                if (join2._rightTable.equals(tableName)) {
                    sql.append(this._factory.quoteName(tableName));
                } else {
                    sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(join2._rightTable));
                }
                sql.append(" ON ");
                for (int j2 = 0; j2 < join2._leftColumns.length; ++j2) {
                    if (j2 > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this._factory.quoteName(join2._leftTable + "." + join2._leftColumns[j2])).append("=");
                    sql.append(this._factory.quoteName(join2._rightTable + "." + join2._rightColumns[j2]));
                }
                tables.remove(join2._rightTable);
            }
            done.addElement(join._leftTable);
        }
        Enumeration enumeration = tables.keys();
        while (enumeration.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            String tableAlias = (String)enumeration.nextElement();
            tableName = (String)tables.get(tableAlias);
            if (tableAlias.equals(tableName)) {
                sql.append(this._factory.quoteName(tableName));
                continue;
            }
            sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (join._outer) continue;
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            for (j = 0; j < join._leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join._leftTable + "." + join._leftColumns[j])).append("=");
                sql.append(this._factory.quoteName(join._rightTable + "." + join._rightColumns[j]));
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        return sql.toString();
    }

    public boolean isLimitClauseSupported() {
        return true;
    }

    public boolean isOffsetClauseSupported() {
        return true;
    }
}

