/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.castor.cpa.persistence.sql.query.Delete;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Update;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.visitor.DB2QueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.DefaultQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.InformixQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.MySQLQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.OracleQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.ParameterVisitor;
import org.castor.cpa.persistence.sql.query.visitor.PostgreSQLQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.ProgressQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.SQLServerQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.SapDbQueryVisitor;
import org.castor.cpa.persistence.sql.query.visitor.SybaseQueryVisitor;
import org.castor.jdo.engine.SQLTypeInfos;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class CastorStatement {
    private final PersistenceFactory _factory;
    private final Connection _connection;
    private PreparedStatement _statement;
    private Map<String, Integer> _parameters;
    private Visitor _queryVis;

    public CastorStatement(PersistenceFactory factory, Connection connection) {
        this._factory = factory;
        this._connection = connection;
    }

    public PreparedStatement getStatement() {
        return this._statement;
    }

    public void setStatement(PreparedStatement stmt) {
        this._statement = stmt;
    }

    public int getParameterSize() throws SQLException {
        if (this._parameters == null) {
            throw new SQLException("Parameters not prepared!");
        }
        return this._parameters.size();
    }

    public void prepareStatement(Select select) throws SQLException {
        ParameterVisitor parmVis = new ParameterVisitor();
        parmVis.visit(select);
        this._parameters = parmVis.getParameters();
        this._queryVis = this.getMatchingQueryVisitor(this._factory.getFactoryName());
        this._queryVis.visit(select);
        this._statement = this._connection.prepareStatement(((Object)this._queryVis).toString());
    }

    public void prepareStatement(Insert insert) throws SQLException {
        ParameterVisitor parmVis = new ParameterVisitor();
        parmVis.visit(insert);
        this._parameters = parmVis.getParameters();
        this._queryVis = this.getMatchingQueryVisitor(this._factory.getFactoryName());
        this._queryVis.visit(insert);
        this._statement = this._connection.prepareStatement(((Object)this._queryVis).toString());
    }

    public void prepareStatement(Update update, Condition condition) throws SQLException {
        update.setCondition(condition);
        ParameterVisitor parmVis = new ParameterVisitor();
        parmVis.visit(update);
        this._parameters = parmVis.getParameters();
        this._queryVis = this.getMatchingQueryVisitor(this._factory.getFactoryName());
        this._queryVis.visit(update);
        this._statement = this._connection.prepareStatement(((Object)this._queryVis).toString());
    }

    public void prepareStatement(Delete delete) throws SQLException {
        ParameterVisitor parmVis = new ParameterVisitor();
        parmVis.visit(delete);
        this._parameters = parmVis.getParameters();
        this._queryVis = this.getMatchingQueryVisitor(this._factory.getFactoryName());
        this._queryVis.visit(delete);
        this._statement = this._connection.prepareStatement(((Object)this._queryVis).toString());
    }

    public void bindParameter(String name, Object value, int type) throws SQLException {
        if (this._statement == null) {
            throw new SQLException("Statment not prepared!");
        }
        if (this._parameters == null) {
            throw new SQLException("Parameters not prepared!");
        }
        Integer index = this._parameters.get(name);
        if (index != null) {
            SQLTypeInfos.setValue(this._statement, index, value, type);
        } else {
            System.out.println("Unknown parameter: " + name);
        }
    }

    public int executeUpdate() throws SQLException {
        if (this._statement == null) {
            throw new SQLException("Statment not prepared!");
        }
        return this._statement.executeUpdate();
    }

    public ResultSet executeQuery() throws SQLException {
        if (this._statement == null) {
            throw new SQLException("Statment not prepared!");
        }
        return this._statement.executeQuery();
    }

    public void close() throws SQLException {
        this._queryVis = null;
        if (this._statement != null) {
            this._statement.close();
            this._statement = null;
        }
    }

    public String toString() {
        if (this._queryVis == null) {
            return null;
        }
        return ((Object)this._queryVis).toString();
    }

    private Visitor getMatchingQueryVisitor(String factoryName) {
        if (factoryName == "db2") {
            return new DB2QueryVisitor();
        }
        if (factoryName == "informix") {
            return new InformixQueryVisitor();
        }
        if (factoryName == "mysql") {
            return new MySQLQueryVisitor();
        }
        if (factoryName == "oracle") {
            return new OracleQueryVisitor();
        }
        if (factoryName == "postgresql") {
            return new PostgreSQLQueryVisitor();
        }
        if (factoryName == "progress") {
            return new ProgressQueryVisitor();
        }
        if (factoryName == "sapdb") {
            return new SapDbQueryVisitor();
        }
        if (factoryName == "sql-server") {
            return new SQLServerQueryVisitor();
        }
        if (factoryName == "sybase") {
            return new SybaseQueryVisitor();
        }
        return new DefaultQueryVisitor();
    }
}

