/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.SQLStatementUpdateCheck;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.TableInfo;
import org.castor.cpa.persistence.sql.query.Update;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;

public final class SQLStatementUpdate {
    private static final Log LOG = LogFactory.getLog(SQLStatementUpdate.class);
    private static final String SET_PARAM_NAMESPACE = "SET:";
    private final String _type;
    private Update _update;
    private TableInfo _tableInfo;
    private boolean _hasFieldsToPersist;
    private final SQLStatementUpdateCheck _statementUpdateCheck;

    public SQLStatementUpdate(SQLEngine engine) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._tableInfo = engine.getTableInfo();
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
        this._statementUpdateCheck = new SQLStatementUpdateCheck(engine);
    }

    private void buildStatement(String mapTo) {
        this._update = new Update(mapTo);
        int count = 0;
        for (ColumnInfo col : this._tableInfo.iterateAll()) {
            if (!col.isStore()) continue;
            this._update.addAssignment(new Column(col.getName()), new Parameter(SET_PARAM_NAMESPACE + col.getName()));
            ++count;
        }
        boolean bl = this._hasFieldsToPersist = count > 0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("hasFieldsToPersist = " + this._hasFieldsToPersist));
        }
    }

    public Object executeStatement(CastorConnection conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        if (this._hasFieldsToPersist) {
            CastorStatement stmt = conn.createStatement();
            AndCondition condition = new AndCondition();
            for (ColumnInfo col : this._tableInfo.getPrimaryKey().getColumns()) {
                String name = col.getName();
                ((Condition)condition).and(new Column(name).equal(new Parameter(name)));
            }
            this.appendOldEntityCondition(oldentity, condition);
            try {
                stmt.prepareStatement(this._update, condition);
                this.bindNewEntity(newentity, stmt);
                this.bindIdentity(identity, stmt);
                this.bindOldEntity(oldentity, stmt);
                if (stmt.executeUpdate() <= 0) {
                    this._statementUpdateCheck.updateFailureCheck(conn, identity);
                }
            }
            catch (SQLException ex) {
                LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._type, (Object)stmt.toString()), (Throwable)ex);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)ex), ex);
            }
            finally {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
            }
        }
        return null;
    }

    private void appendOldEntityCondition(ProposedEntity oldentity, Condition condition) throws PersistenceException {
        if (oldentity.getFields() != null) {
            for (ColumnValue value : this._tableInfo.toSQL(oldentity.getFields())) {
                if (!value.isStore() || !value.isDirty()) continue;
                String name = value.getName();
                if (value.getValue() == null) {
                    condition.and(new Column(name).isNull());
                    continue;
                }
                condition.and(new Column(name).equal(new Parameter(name)));
            }
        }
    }

    private void bindNewEntity(ProposedEntity newentity, CastorStatement stmt) throws PersistenceException, SQLException {
        for (ColumnValue value : this._tableInfo.toSQL(newentity.getFields())) {
            if (!value.isStore()) continue;
            stmt.bindParameter(SET_PARAM_NAMESPACE + value.getName(), value.getValue(), value.getType());
        }
    }

    private void bindIdentity(Identity identity, CastorStatement stmt) throws SQLException {
        for (ColumnValue value : this._tableInfo.toSQL(identity)) {
            stmt.bindParameter(value.getName(), value.getValue(), value.getType());
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)value.getName(), (Object)value.getValue()));
        }
    }

    private void bindOldEntity(ProposedEntity oldentity, CastorStatement stmt) throws PersistenceException, SQLException {
        for (ColumnValue value : this._tableInfo.toSQL(oldentity.getFields())) {
            if (!value.isStore() || !value.isDirty() || value.getValue() == null) continue;
            stmt.bindParameter(value.getName(), value.getValue(), value.getType());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.storing", (Object)this._type, (Object)stmt.toString()));
        }
    }
}

